package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReferencePredictorSummary(
    arn: Optional[Arn] = Optional.Absent,
    state: Optional[zio.aws.forecast.model.State] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ReferencePredictorSummary = {
    import ReferencePredictorSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ReferencePredictorSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ReferencePredictorSummary.ReadOnly =
    zio.aws.forecast.model.ReferencePredictorSummary.wrap(buildAwsValue())
}
object ReferencePredictorSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ReferencePredictorSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ReferencePredictorSummary =
      zio.aws.forecast.model.ReferencePredictorSummary(
        arn.map(value => value),
        state.map(value => value)
      )
    def arn: Optional[Arn]
    def state: Optional[zio.aws.forecast.model.State]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getState: ZIO[Any, AwsError, zio.aws.forecast.model.State] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ReferencePredictorSummary
  ) extends zio.aws.forecast.model.ReferencePredictorSummary.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val state: Optional[zio.aws.forecast.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.forecast.model.State.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ReferencePredictorSummary
  ): zio.aws.forecast.model.ReferencePredictorSummary.ReadOnly = new Wrapper(
    impl
  )
}
