package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopResourceRequest(resourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.StopResourceRequest = {
    import StopResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.StopResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.StopResourceRequest.ReadOnly =
    zio.aws.forecast.model.StopResourceRequest.wrap(buildAwsValue())
}
object StopResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.StopResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.StopResourceRequest =
      zio.aws.forecast.model.StopResourceRequest(resourceArn)
    def resourceArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.StopResourceRequest
  ) extends zio.aws.forecast.model.StopResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.StopResourceRequest
  ): zio.aws.forecast.model.StopResourceRequest.ReadOnly = new Wrapper(impl)
}
