package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Value, Name}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SupplementaryFeature(name: Name, value: Value) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.SupplementaryFeature = {
    import SupplementaryFeature.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.SupplementaryFeature
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .value(Value.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.SupplementaryFeature.ReadOnly =
    zio.aws.forecast.model.SupplementaryFeature.wrap(buildAwsValue())
}
object SupplementaryFeature {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.SupplementaryFeature
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.SupplementaryFeature =
      zio.aws.forecast.model.SupplementaryFeature(name, value)
    def name: Name
    def value: Value
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, Value] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.SupplementaryFeature
  ) extends zio.aws.forecast.model.SupplementaryFeature.ReadOnly {
    override val name: Name =
      zio.aws.forecast.model.primitives.Name(impl.name())
    override val value: Value =
      zio.aws.forecast.model.primitives.Value(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.SupplementaryFeature
  ): zio.aws.forecast.model.SupplementaryFeature.ReadOnly = new Wrapper(impl)
}
