package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Format
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TimeSeriesIdentifiers(
    dataSource: Optional[zio.aws.forecast.model.DataSource] = Optional.Absent,
    schema: Optional[zio.aws.forecast.model.Schema] = Optional.Absent,
    format: Optional[Format] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.TimeSeriesIdentifiers = {
    import TimeSeriesIdentifiers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.TimeSeriesIdentifiers
      .builder()
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .optionallyWith(schema.map(value => value.buildAwsValue()))(_.schema)
      .optionallyWith(
        format.map(value => Format.unwrap(value): java.lang.String)
      )(_.format)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.TimeSeriesIdentifiers.ReadOnly =
    zio.aws.forecast.model.TimeSeriesIdentifiers.wrap(buildAwsValue())
}
object TimeSeriesIdentifiers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.TimeSeriesIdentifiers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.TimeSeriesIdentifiers =
      zio.aws.forecast.model.TimeSeriesIdentifiers(
        dataSource.map(value => value.asEditable),
        schema.map(value => value.asEditable),
        format.map(value => value)
      )
    def dataSource: Optional[zio.aws.forecast.model.DataSource.ReadOnly]
    def schema: Optional[zio.aws.forecast.model.Schema.ReadOnly]
    def format: Optional[Format]
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataSource.ReadOnly] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getSchema: ZIO[Any, AwsError, zio.aws.forecast.model.Schema.ReadOnly] =
      AwsError.unwrapOptionField("schema", schema)
    def getFormat: ZIO[Any, AwsError, Format] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.TimeSeriesIdentifiers
  ) extends zio.aws.forecast.model.TimeSeriesIdentifiers.ReadOnly {
    override val dataSource
        : Optional[zio.aws.forecast.model.DataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSource())
        .map(value => zio.aws.forecast.model.DataSource.wrap(value))
    override val schema: Optional[zio.aws.forecast.model.Schema.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schema())
        .map(value => zio.aws.forecast.model.Schema.wrap(value))
    override val format: Optional[Format] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.forecast.model.primitives.Format(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.TimeSeriesIdentifiers
  ): zio.aws.forecast.model.TimeSeriesIdentifiers.ReadOnly = new Wrapper(impl)
}
