package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TimeSeriesSelector(
    timeSeriesIdentifiers: Optional[
      zio.aws.forecast.model.TimeSeriesIdentifiers
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.TimeSeriesSelector = {
    import TimeSeriesSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.TimeSeriesSelector
      .builder()
      .optionallyWith(
        timeSeriesIdentifiers.map(value => value.buildAwsValue())
      )(_.timeSeriesIdentifiers)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.TimeSeriesSelector.ReadOnly =
    zio.aws.forecast.model.TimeSeriesSelector.wrap(buildAwsValue())
}
object TimeSeriesSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.TimeSeriesSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.TimeSeriesSelector =
      zio.aws.forecast.model.TimeSeriesSelector(
        timeSeriesIdentifiers.map(value => value.asEditable)
      )
    def timeSeriesIdentifiers
        : Optional[zio.aws.forecast.model.TimeSeriesIdentifiers.ReadOnly]
    def getTimeSeriesIdentifiers: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.TimeSeriesIdentifiers.ReadOnly
    ] =
      AwsError.unwrapOptionField("timeSeriesIdentifiers", timeSeriesIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.TimeSeriesSelector
  ) extends zio.aws.forecast.model.TimeSeriesSelector.ReadOnly {
    override val timeSeriesIdentifiers
        : Optional[zio.aws.forecast.model.TimeSeriesIdentifiers.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSeriesIdentifiers())
        .map(value => zio.aws.forecast.model.TimeSeriesIdentifiers.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.TimeSeriesSelector
  ): zio.aws.forecast.model.TimeSeriesSelector.ReadOnly = new Wrapper(impl)
}
