package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TimeSeriesTransformation(
    action: Optional[zio.aws.forecast.model.Action] = Optional.Absent,
    timeSeriesConditions: Optional[
      Iterable[zio.aws.forecast.model.TimeSeriesCondition]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation = {
    import TimeSeriesTransformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(
        timeSeriesConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeSeriesConditions)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.TimeSeriesTransformation.ReadOnly =
    zio.aws.forecast.model.TimeSeriesTransformation.wrap(buildAwsValue())
}
object TimeSeriesTransformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.TimeSeriesTransformation =
      zio.aws.forecast.model.TimeSeriesTransformation(
        action.map(value => value.asEditable),
        timeSeriesConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def action: Optional[zio.aws.forecast.model.Action.ReadOnly]
    def timeSeriesConditions
        : Optional[List[zio.aws.forecast.model.TimeSeriesCondition.ReadOnly]]
    def getAction: ZIO[Any, AwsError, zio.aws.forecast.model.Action.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getTimeSeriesConditions: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.TimeSeriesCondition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("timeSeriesConditions", timeSeriesConditions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation
  ) extends zio.aws.forecast.model.TimeSeriesTransformation.ReadOnly {
    override val action: Optional[zio.aws.forecast.model.Action.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.forecast.model.Action.wrap(value))
    override val timeSeriesConditions
        : Optional[List[zio.aws.forecast.model.TimeSeriesCondition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSeriesConditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.TimeSeriesCondition.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation
  ): zio.aws.forecast.model.TimeSeriesTransformation.ReadOnly = new Wrapper(
    impl
  )
}
