package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  ErrorMessage,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class WhatIfAnalysisSummary(
    whatIfAnalysisArn: Optional[Arn] = Optional.Absent,
    whatIfAnalysisName: Optional[Name] = Optional.Absent,
    forecastArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.WhatIfAnalysisSummary = {
    import WhatIfAnalysisSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.WhatIfAnalysisSummary
      .builder()
      .optionallyWith(
        whatIfAnalysisArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.whatIfAnalysisArn)
      .optionallyWith(
        whatIfAnalysisName.map(value => Name.unwrap(value): java.lang.String)
      )(_.whatIfAnalysisName)
      .optionallyWith(
        forecastArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.forecastArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.WhatIfAnalysisSummary.ReadOnly =
    zio.aws.forecast.model.WhatIfAnalysisSummary.wrap(buildAwsValue())
}
object WhatIfAnalysisSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.WhatIfAnalysisSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.WhatIfAnalysisSummary =
      zio.aws.forecast.model.WhatIfAnalysisSummary(
        whatIfAnalysisArn.map(value => value),
        whatIfAnalysisName.map(value => value),
        forecastArn.map(value => value),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def whatIfAnalysisArn: Optional[Arn]
    def whatIfAnalysisName: Optional[Name]
    def forecastArn: Optional[Arn]
    def status: Optional[Status]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getWhatIfAnalysisArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("whatIfAnalysisArn", whatIfAnalysisArn)
    def getWhatIfAnalysisName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("whatIfAnalysisName", whatIfAnalysisName)
    def getForecastArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("forecastArn", forecastArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.WhatIfAnalysisSummary
  ) extends zio.aws.forecast.model.WhatIfAnalysisSummary.ReadOnly {
    override val whatIfAnalysisArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfAnalysisArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val whatIfAnalysisName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfAnalysisName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val forecastArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.WhatIfAnalysisSummary
  ): zio.aws.forecast.model.WhatIfAnalysisSummary.ReadOnly = new Wrapper(impl)
}
