package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Value, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AdditionalDataset(
    name: Name,
    configuration: Optional[Map[Name, Iterable[Value]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.AdditionalDataset = {
    import AdditionalDataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.AdditionalDataset
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.map { item =>
                Value.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.configuration)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.AdditionalDataset.ReadOnly =
    zio.aws.forecast.model.AdditionalDataset.wrap(buildAwsValue())
}
object AdditionalDataset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.AdditionalDataset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.AdditionalDataset =
      zio.aws.forecast.model
        .AdditionalDataset(name, configuration.map(value => value))
    def name: Name
    def configuration: Optional[Map[Name, List[Value]]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getConfiguration: ZIO[Any, AwsError, Map[Name, List[Value]]] =
      AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.AdditionalDataset
  ) extends zio.aws.forecast.model.AdditionalDataset.ReadOnly {
    override val name: Name =
      zio.aws.forecast.model.primitives.Name(impl.name())
    override val configuration: Optional[Map[Name, List[Value]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.forecast.model.primitives.Name(key) -> value.asScala.map {
                item =>
                  zio.aws.forecast.model.primitives.Value(item)
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.AdditionalDataset
  ): zio.aws.forecast.model.AdditionalDataset.ReadOnly = new Wrapper(impl)
}
