package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Name
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BaselineMetric(
    name: Optional[Name] = Optional.Absent,
    value: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.BaselineMetric = {
    import BaselineMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.BaselineMetric
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(value.map(value => value: java.lang.Double))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.BaselineMetric.ReadOnly =
    zio.aws.forecast.model.BaselineMetric.wrap(buildAwsValue())
}
object BaselineMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.BaselineMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.BaselineMetric =
      zio.aws.forecast.model
        .BaselineMetric(name.map(value => value), value.map(value => value))
    def name: Optional[Name]
    def value: Optional[Double]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.BaselineMetric
  ) extends zio.aws.forecast.model.BaselineMetric.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val value: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.BaselineMetric
  ): zio.aws.forecast.model.BaselineMetric.ReadOnly = new Wrapper(impl)
}
