package zio.aws.forecast.model
import scala.jdk.CollectionConverters._
sealed trait Condition {
  def unwrap: software.amazon.awssdk.services.forecast.model.Condition
}
object Condition {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.Condition
  ): zio.aws.forecast.model.Condition = value match {
    case software.amazon.awssdk.services.forecast.model.Condition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.Condition.EQUALS =>
      val r = EQUALS
      r
    case software.amazon.awssdk.services.forecast.model.Condition.NOT_EQUALS =>
      val r = NOT_EQUALS
      r
    case software.amazon.awssdk.services.forecast.model.Condition.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.forecast.model.Condition.GREATER_THAN =>
      val r = GREATER_THAN
      r
  }
  case object unknownToSdkVersion extends zio.aws.forecast.model.Condition {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.Condition =
      software.amazon.awssdk.services.forecast.model.Condition.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.forecast.model.Condition {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.Condition =
      software.amazon.awssdk.services.forecast.model.Condition.EQUALS
  }
  case object NOT_EQUALS extends zio.aws.forecast.model.Condition {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.Condition =
      software.amazon.awssdk.services.forecast.model.Condition.NOT_EQUALS
  }
  case object LESS_THAN extends zio.aws.forecast.model.Condition {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.Condition =
      software.amazon.awssdk.services.forecast.model.Condition.LESS_THAN
  }
  case object GREATER_THAN extends zio.aws.forecast.model.Condition {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.Condition =
      software.amazon.awssdk.services.forecast.model.Condition.GREATER_THAN
  }
}
