package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{LocalDateTime, Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateExplainabilityRequest(
    explainabilityName: Name,
    resourceArn: Arn,
    explainabilityConfig: zio.aws.forecast.model.ExplainabilityConfig,
    dataSource: Optional[zio.aws.forecast.model.DataSource] = Optional.Absent,
    schema: Optional[zio.aws.forecast.model.Schema] = Optional.Absent,
    enableVisualization: Optional[Boolean] = Optional.Absent,
    startDateTime: Optional[LocalDateTime] = Optional.Absent,
    endDateTime: Optional[LocalDateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateExplainabilityRequest = {
    import CreateExplainabilityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateExplainabilityRequest
      .builder()
      .explainabilityName(Name.unwrap(explainabilityName): java.lang.String)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .explainabilityConfig(explainabilityConfig.buildAwsValue())
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .optionallyWith(schema.map(value => value.buildAwsValue()))(_.schema)
      .optionallyWith(
        enableVisualization.map(value => value: java.lang.Boolean)
      )(_.enableVisualization)
      .optionallyWith(
        startDateTime.map(value =>
          LocalDateTime.unwrap(value): java.lang.String
        )
      )(_.startDateTime)
      .optionallyWith(
        endDateTime.map(value => LocalDateTime.unwrap(value): java.lang.String)
      )(_.endDateTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateExplainabilityRequest.ReadOnly =
    zio.aws.forecast.model.CreateExplainabilityRequest.wrap(buildAwsValue())
}
object CreateExplainabilityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateExplainabilityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateExplainabilityRequest =
      zio.aws.forecast.model.CreateExplainabilityRequest(
        explainabilityName,
        resourceArn,
        explainabilityConfig.asEditable,
        dataSource.map(value => value.asEditable),
        schema.map(value => value.asEditable),
        enableVisualization.map(value => value),
        startDateTime.map(value => value),
        endDateTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def explainabilityName: Name
    def resourceArn: Arn
    def explainabilityConfig
        : zio.aws.forecast.model.ExplainabilityConfig.ReadOnly
    def dataSource: Optional[zio.aws.forecast.model.DataSource.ReadOnly]
    def schema: Optional[zio.aws.forecast.model.Schema.ReadOnly]
    def enableVisualization: Optional[Boolean]
    def startDateTime: Optional[LocalDateTime]
    def endDateTime: Optional[LocalDateTime]
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def getExplainabilityName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(explainabilityName)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getExplainabilityConfig: ZIO[
      Any,
      Nothing,
      zio.aws.forecast.model.ExplainabilityConfig.ReadOnly
    ] = ZIO.succeed(explainabilityConfig)
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataSource.ReadOnly] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getSchema: ZIO[Any, AwsError, zio.aws.forecast.model.Schema.ReadOnly] =
      AwsError.unwrapOptionField("schema", schema)
    def getEnableVisualization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableVisualization", enableVisualization)
    def getStartDateTime: ZIO[Any, AwsError, LocalDateTime] =
      AwsError.unwrapOptionField("startDateTime", startDateTime)
    def getEndDateTime: ZIO[Any, AwsError, LocalDateTime] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateExplainabilityRequest
  ) extends zio.aws.forecast.model.CreateExplainabilityRequest.ReadOnly {
    override val explainabilityName: Name =
      zio.aws.forecast.model.primitives.Name(impl.explainabilityName())
    override val resourceArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.resourceArn())
    override val explainabilityConfig
        : zio.aws.forecast.model.ExplainabilityConfig.ReadOnly =
      zio.aws.forecast.model.ExplainabilityConfig
        .wrap(impl.explainabilityConfig())
    override val dataSource
        : Optional[zio.aws.forecast.model.DataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSource())
        .map(value => zio.aws.forecast.model.DataSource.wrap(value))
    override val schema: Optional[zio.aws.forecast.model.Schema.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schema())
        .map(value => zio.aws.forecast.model.Schema.wrap(value))
    override val enableVisualization: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableVisualization())
      .map(value => value: Boolean)
    override val startDateTime: Optional[LocalDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startDateTime())
      .map(value => zio.aws.forecast.model.primitives.LocalDateTime(value))
    override val endDateTime: Optional[LocalDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDateTime())
      .map(value => zio.aws.forecast.model.primitives.LocalDateTime(value))
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateExplainabilityRequest
  ): zio.aws.forecast.model.CreateExplainabilityRequest.ReadOnly = new Wrapper(
    impl
  )
}
