package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{ForecastType, Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateForecastRequest(
    forecastName: Name,
    predictorArn: Arn,
    forecastTypes: Optional[Iterable[ForecastType]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent,
    timeSeriesSelector: Optional[zio.aws.forecast.model.TimeSeriesSelector] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateForecastRequest = {
    import CreateForecastRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateForecastRequest
      .builder()
      .forecastName(Name.unwrap(forecastName): java.lang.String)
      .predictorArn(Arn.unwrap(predictorArn): java.lang.String)
      .optionallyWith(
        forecastTypes.map(value =>
          value.map { item =>
            ForecastType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastTypes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(timeSeriesSelector.map(value => value.buildAwsValue()))(
        _.timeSeriesSelector
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateForecastRequest.ReadOnly =
    zio.aws.forecast.model.CreateForecastRequest.wrap(buildAwsValue())
}
object CreateForecastRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateForecastRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateForecastRequest =
      zio.aws.forecast.model.CreateForecastRequest(
        forecastName,
        predictorArn,
        forecastTypes.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timeSeriesSelector.map(value => value.asEditable)
      )
    def forecastName: Name
    def predictorArn: Arn
    def forecastTypes: Optional[List[ForecastType]]
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def timeSeriesSelector
        : Optional[zio.aws.forecast.model.TimeSeriesSelector.ReadOnly]
    def getForecastName: ZIO[Any, Nothing, Name] = ZIO.succeed(forecastName)
    def getPredictorArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(predictorArn)
    def getForecastTypes: ZIO[Any, AwsError, List[ForecastType]] =
      AwsError.unwrapOptionField("forecastTypes", forecastTypes)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTimeSeriesSelector: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.TimeSeriesSelector.ReadOnly
    ] = AwsError.unwrapOptionField("timeSeriesSelector", timeSeriesSelector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateForecastRequest
  ) extends zio.aws.forecast.model.CreateForecastRequest.ReadOnly {
    override val forecastName: Name =
      zio.aws.forecast.model.primitives.Name(impl.forecastName())
    override val predictorArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.predictorArn())
    override val forecastTypes: Optional[List[ForecastType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.ForecastType(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
    override val timeSeriesSelector
        : Optional[zio.aws.forecast.model.TimeSeriesSelector.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSeriesSelector())
        .map(value => zio.aws.forecast.model.TimeSeriesSelector.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateForecastRequest
  ): zio.aws.forecast.model.CreateForecastRequest.ReadOnly = new Wrapper(impl)
}
