package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataConfig(
    datasetGroupArn: Arn,
    attributeConfigs: Optional[
      Iterable[zio.aws.forecast.model.AttributeConfig]
    ] = Optional.Absent,
    additionalDatasets: Optional[
      Iterable[zio.aws.forecast.model.AdditionalDataset]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DataConfig = {
    import DataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DataConfig
      .builder()
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .optionallyWith(
        attributeConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeConfigs)
      .optionallyWith(
        additionalDatasets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalDatasets)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DataConfig.ReadOnly =
    zio.aws.forecast.model.DataConfig.wrap(buildAwsValue())
}
object DataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DataConfig =
      zio.aws.forecast.model.DataConfig(
        datasetGroupArn,
        attributeConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        additionalDatasets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def datasetGroupArn: Arn
    def attributeConfigs
        : Optional[List[zio.aws.forecast.model.AttributeConfig.ReadOnly]]
    def additionalDatasets
        : Optional[List[zio.aws.forecast.model.AdditionalDataset.ReadOnly]]
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
    def getAttributeConfigs: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.AttributeConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("attributeConfigs", attributeConfigs)
    def getAdditionalDatasets: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.AdditionalDataset.ReadOnly
    ]] = AwsError.unwrapOptionField("additionalDatasets", additionalDatasets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DataConfig
  ) extends zio.aws.forecast.model.DataConfig.ReadOnly {
    override val datasetGroupArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.datasetGroupArn())
    override val attributeConfigs
        : Optional[List[zio.aws.forecast.model.AttributeConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.AttributeConfig.wrap(item)
          }.toList
        )
    override val additionalDatasets
        : Optional[List[zio.aws.forecast.model.AdditionalDataset.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalDatasets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.AdditionalDataset.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DataConfig
  ): zio.aws.forecast.model.DataConfig.ReadOnly = new Wrapper(impl)
}
