package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteExplainabilityRequest(explainabilityArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteExplainabilityRequest = {
    import DeleteExplainabilityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteExplainabilityRequest
      .builder()
      .explainabilityArn(Arn.unwrap(explainabilityArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DeleteExplainabilityRequest.ReadOnly =
    zio.aws.forecast.model.DeleteExplainabilityRequest.wrap(buildAwsValue())
}
object DeleteExplainabilityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteExplainabilityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteExplainabilityRequest =
      zio.aws.forecast.model.DeleteExplainabilityRequest(explainabilityArn)
    def explainabilityArn: Arn
    def getExplainabilityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(explainabilityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteExplainabilityRequest
  ) extends zio.aws.forecast.model.DeleteExplainabilityRequest.ReadOnly {
    override val explainabilityArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.explainabilityArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteExplainabilityRequest
  ): zio.aws.forecast.model.DeleteExplainabilityRequest.ReadOnly = new Wrapper(
    impl
  )
}
