package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePredictorRequest(predictorArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeletePredictorRequest = {
    import DeletePredictorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeletePredictorRequest
      .builder()
      .predictorArn(Arn.unwrap(predictorArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DeletePredictorRequest.ReadOnly =
    zio.aws.forecast.model.DeletePredictorRequest.wrap(buildAwsValue())
}
object DeletePredictorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeletePredictorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeletePredictorRequest =
      zio.aws.forecast.model.DeletePredictorRequest(predictorArn)
    def predictorArn: Arn
    def getPredictorArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(predictorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeletePredictorRequest
  ) extends zio.aws.forecast.model.DeletePredictorRequest.ReadOnly {
    override val predictorArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.predictorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeletePredictorRequest
  ): zio.aws.forecast.model.DeletePredictorRequest.ReadOnly = new Wrapper(impl)
}
