package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWhatIfAnalysisRequest(whatIfAnalysisArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteWhatIfAnalysisRequest = {
    import DeleteWhatIfAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteWhatIfAnalysisRequest
      .builder()
      .whatIfAnalysisArn(Arn.unwrap(whatIfAnalysisArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DeleteWhatIfAnalysisRequest.ReadOnly =
    zio.aws.forecast.model.DeleteWhatIfAnalysisRequest.wrap(buildAwsValue())
}
object DeleteWhatIfAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteWhatIfAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteWhatIfAnalysisRequest =
      zio.aws.forecast.model.DeleteWhatIfAnalysisRequest(whatIfAnalysisArn)
    def whatIfAnalysisArn: Arn
    def getWhatIfAnalysisArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(whatIfAnalysisArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteWhatIfAnalysisRequest
  ) extends zio.aws.forecast.model.DeleteWhatIfAnalysisRequest.ReadOnly {
    override val whatIfAnalysisArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.whatIfAnalysisArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteWhatIfAnalysisRequest
  ): zio.aws.forecast.model.DeleteWhatIfAnalysisRequest.ReadOnly = new Wrapper(
    impl
  )
}
