package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAutoPredictorRequest(predictorArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorRequest = {
    import DescribeAutoPredictorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorRequest
      .builder()
      .predictorArn(Arn.unwrap(predictorArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribeAutoPredictorRequest.ReadOnly =
    zio.aws.forecast.model.DescribeAutoPredictorRequest.wrap(buildAwsValue())
}
object DescribeAutoPredictorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeAutoPredictorRequest =
      zio.aws.forecast.model.DescribeAutoPredictorRequest(predictorArn)
    def predictorArn: Arn
    def getPredictorArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(predictorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorRequest
  ) extends zio.aws.forecast.model.DescribeAutoPredictorRequest.ReadOnly {
    override val predictorArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.predictorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorRequest
  ): zio.aws.forecast.model.DescribeAutoPredictorRequest.ReadOnly = new Wrapper(
    impl
  )
}
