package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{Timestamp, Status, Arn, Name}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeDatasetGroupResponse(
    datasetGroupName: Optional[Name] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    datasetArns: Optional[Iterable[Arn]] = Optional.Absent,
    domain: Optional[zio.aws.forecast.model.Domain] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupResponse = {
    import DescribeDatasetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupResponse
      .builder()
      .optionallyWith(
        datasetGroupName.map(value => Name.unwrap(value): java.lang.String)
      )(_.datasetGroupName)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        datasetArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.datasetArns)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribeDatasetGroupResponse.ReadOnly =
    zio.aws.forecast.model.DescribeDatasetGroupResponse.wrap(buildAwsValue())
}
object DescribeDatasetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeDatasetGroupResponse =
      zio.aws.forecast.model.DescribeDatasetGroupResponse(
        datasetGroupName.map(value => value),
        datasetGroupArn.map(value => value),
        datasetArns.map(value => value),
        domain.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def datasetGroupName: Optional[Name]
    def datasetGroupArn: Optional[Arn]
    def datasetArns: Optional[List[Arn]]
    def domain: Optional[zio.aws.forecast.model.Domain]
    def status: Optional[Status]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getDatasetGroupName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("datasetGroupName", datasetGroupName)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getDatasetArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("datasetArns", datasetArns)
    def getDomain: ZIO[Any, AwsError, zio.aws.forecast.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupResponse
  ) extends zio.aws.forecast.model.DescribeDatasetGroupResponse.ReadOnly {
    override val datasetGroupName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val datasetArns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.primitives.Arn(item)
        }.toList
      )
    override val domain: Optional[zio.aws.forecast.model.Domain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.forecast.model.Domain.wrap(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupResponse
  ): zio.aws.forecast.model.DescribeDatasetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
