package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeForecastRequest(forecastArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeForecastRequest = {
    import DescribeForecastRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeForecastRequest
      .builder()
      .forecastArn(Arn.unwrap(forecastArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribeForecastRequest.ReadOnly =
    zio.aws.forecast.model.DescribeForecastRequest.wrap(buildAwsValue())
}
object DescribeForecastRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeForecastRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeForecastRequest =
      zio.aws.forecast.model.DescribeForecastRequest(forecastArn)
    def forecastArn: Arn
    def getForecastArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(forecastArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeForecastRequest
  ) extends zio.aws.forecast.model.DescribeForecastRequest.ReadOnly {
    override val forecastArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.forecastArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeForecastRequest
  ): zio.aws.forecast.model.DescribeForecastRequest.ReadOnly = new Wrapper(impl)
}
