package zio.aws.forecast.model
import scala.jdk.CollectionConverters._
sealed trait Domain {
  def unwrap: software.amazon.awssdk.services.forecast.model.Domain
}
object Domain {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.Domain
  ): zio.aws.forecast.model.Domain = value match {
    case software.amazon.awssdk.services.forecast.model.Domain.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.Domain.RETAIL =>
      val r = RETAIL
      r
    case software.amazon.awssdk.services.forecast.model.Domain.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.forecast.model.Domain.INVENTORY_PLANNING =>
      val r = INVENTORY_PLANNING
      r
    case software.amazon.awssdk.services.forecast.model.Domain.EC2_CAPACITY =>
      val r = EC2_CAPACITY
      r
    case software.amazon.awssdk.services.forecast.model.Domain.WORK_FORCE =>
      val r = WORK_FORCE
      r
    case software.amazon.awssdk.services.forecast.model.Domain.WEB_TRAFFIC =>
      val r = WEB_TRAFFIC
      r
    case software.amazon.awssdk.services.forecast.model.Domain.METRICS =>
      val r = METRICS
      r
  }
  case object unknownToSdkVersion extends zio.aws.forecast.model.Domain {
    override def unwrap: software.amazon.awssdk.services.forecast.model.Domain =
      software.amazon.awssdk.services.forecast.model.Domain.UNKNOWN_TO_SDK_VERSION
  }
  case object RETAIL extends zio.aws.forecast.model.Domain {
    override def unwrap: software.amazon.awssdk.services.forecast.model.Domain =
      software.amazon.awssdk.services.forecast.model.Domain.RETAIL
  }
  case object CUSTOM extends zio.aws.forecast.model.Domain {
    override def unwrap: software.amazon.awssdk.services.forecast.model.Domain =
      software.amazon.awssdk.services.forecast.model.Domain.CUSTOM
  }
  case object INVENTORY_PLANNING extends zio.aws.forecast.model.Domain {
    override def unwrap: software.amazon.awssdk.services.forecast.model.Domain =
      software.amazon.awssdk.services.forecast.model.Domain.INVENTORY_PLANNING
  }
  case object EC2_CAPACITY extends zio.aws.forecast.model.Domain {
    override def unwrap: software.amazon.awssdk.services.forecast.model.Domain =
      software.amazon.awssdk.services.forecast.model.Domain.EC2_CAPACITY
  }
  case object WORK_FORCE extends zio.aws.forecast.model.Domain {
    override def unwrap: software.amazon.awssdk.services.forecast.model.Domain =
      software.amazon.awssdk.services.forecast.model.Domain.WORK_FORCE
  }
  case object WEB_TRAFFIC extends zio.aws.forecast.model.Domain {
    override def unwrap: software.amazon.awssdk.services.forecast.model.Domain =
      software.amazon.awssdk.services.forecast.model.Domain.WEB_TRAFFIC
  }
  case object METRICS extends zio.aws.forecast.model.Domain {
    override def unwrap: software.amazon.awssdk.services.forecast.model.Domain =
      software.amazon.awssdk.services.forecast.model.Domain.METRICS
  }
}
