package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{KMSKeyArn, Arn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EncryptionConfig(roleArn: Arn, kmsKeyArn: KMSKeyArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.EncryptionConfig = {
    import EncryptionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.EncryptionConfig
      .builder()
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .kmsKeyArn(KMSKeyArn.unwrap(kmsKeyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.EncryptionConfig.ReadOnly =
    zio.aws.forecast.model.EncryptionConfig.wrap(buildAwsValue())
}
object EncryptionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.EncryptionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.EncryptionConfig =
      zio.aws.forecast.model.EncryptionConfig(roleArn, kmsKeyArn)
    def roleArn: Arn
    def kmsKeyArn: KMSKeyArn
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getKmsKeyArn: ZIO[Any, Nothing, KMSKeyArn] = ZIO.succeed(kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.EncryptionConfig
  ) extends zio.aws.forecast.model.EncryptionConfig.ReadOnly {
    override val roleArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.roleArn())
    override val kmsKeyArn: KMSKeyArn =
      zio.aws.forecast.model.primitives.KMSKeyArn(impl.kmsKeyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.EncryptionConfig
  ): zio.aws.forecast.model.EncryptionConfig.ReadOnly = new Wrapper(impl)
}
