package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationParameters(
    numberOfBacktestWindows: Optional[Integer] = Optional.Absent,
    backTestWindowOffset: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.EvaluationParameters = {
    import EvaluationParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.EvaluationParameters
      .builder()
      .optionallyWith(
        numberOfBacktestWindows.map(value => value: java.lang.Integer)
      )(_.numberOfBacktestWindows)
      .optionallyWith(
        backTestWindowOffset.map(value => value: java.lang.Integer)
      )(_.backTestWindowOffset)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.EvaluationParameters.ReadOnly =
    zio.aws.forecast.model.EvaluationParameters.wrap(buildAwsValue())
}
object EvaluationParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.EvaluationParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.EvaluationParameters =
      zio.aws.forecast.model.EvaluationParameters(
        numberOfBacktestWindows.map(value => value),
        backTestWindowOffset.map(value => value)
      )
    def numberOfBacktestWindows: Optional[Integer]
    def backTestWindowOffset: Optional[Integer]
    def getNumberOfBacktestWindows: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("numberOfBacktestWindows", numberOfBacktestWindows)
    def getBackTestWindowOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backTestWindowOffset", backTestWindowOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.EvaluationParameters
  ) extends zio.aws.forecast.model.EvaluationParameters.ReadOnly {
    override val numberOfBacktestWindows: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfBacktestWindows())
        .map(value => value: Integer)
    override val backTestWindowOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.backTestWindowOffset())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.EvaluationParameters
  ): zio.aws.forecast.model.EvaluationParameters.ReadOnly = new Wrapper(impl)
}
