package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExplainabilityConfig(
    timeSeriesGranularity: zio.aws.forecast.model.TimeSeriesGranularity,
    timePointGranularity: zio.aws.forecast.model.TimePointGranularity
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ExplainabilityConfig = {
    import ExplainabilityConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ExplainabilityConfig
      .builder()
      .timeSeriesGranularity(timeSeriesGranularity.unwrap)
      .timePointGranularity(timePointGranularity.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ExplainabilityConfig.ReadOnly =
    zio.aws.forecast.model.ExplainabilityConfig.wrap(buildAwsValue())
}
object ExplainabilityConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ExplainabilityConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ExplainabilityConfig =
      zio.aws.forecast.model
        .ExplainabilityConfig(timeSeriesGranularity, timePointGranularity)
    def timeSeriesGranularity: zio.aws.forecast.model.TimeSeriesGranularity
    def timePointGranularity: zio.aws.forecast.model.TimePointGranularity
    def getTimeSeriesGranularity
        : ZIO[Any, Nothing, zio.aws.forecast.model.TimeSeriesGranularity] =
      ZIO.succeed(timeSeriesGranularity)
    def getTimePointGranularity
        : ZIO[Any, Nothing, zio.aws.forecast.model.TimePointGranularity] =
      ZIO.succeed(timePointGranularity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ExplainabilityConfig
  ) extends zio.aws.forecast.model.ExplainabilityConfig.ReadOnly {
    override val timeSeriesGranularity
        : zio.aws.forecast.model.TimeSeriesGranularity =
      zio.aws.forecast.model.TimeSeriesGranularity
        .wrap(impl.timeSeriesGranularity())
    override val timePointGranularity
        : zio.aws.forecast.model.TimePointGranularity =
      zio.aws.forecast.model.TimePointGranularity
        .wrap(impl.timePointGranularity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ExplainabilityConfig
  ): zio.aws.forecast.model.ExplainabilityConfig.ReadOnly = new Wrapper(impl)
}
