package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{ParameterValue, ParameterKey}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FeaturizationMethod(
    featurizationMethodName: zio.aws.forecast.model.FeaturizationMethodName,
    featurizationMethodParameters: Optional[Map[ParameterKey, ParameterValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.FeaturizationMethod = {
    import FeaturizationMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.FeaturizationMethod
      .builder()
      .featurizationMethodName(featurizationMethodName.unwrap)
      .optionallyWith(
        featurizationMethodParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterKey.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.featurizationMethodParameters)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.FeaturizationMethod.ReadOnly =
    zio.aws.forecast.model.FeaturizationMethod.wrap(buildAwsValue())
}
object FeaturizationMethod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.FeaturizationMethod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.FeaturizationMethod =
      zio.aws.forecast.model.FeaturizationMethod(
        featurizationMethodName,
        featurizationMethodParameters.map(value => value)
      )
    def featurizationMethodName: zio.aws.forecast.model.FeaturizationMethodName
    def featurizationMethodParameters
        : Optional[Map[ParameterKey, ParameterValue]]
    def getFeaturizationMethodName
        : ZIO[Any, Nothing, zio.aws.forecast.model.FeaturizationMethodName] =
      ZIO.succeed(featurizationMethodName)
    def getFeaturizationMethodParameters
        : ZIO[Any, AwsError, Map[ParameterKey, ParameterValue]] =
      AwsError.unwrapOptionField(
        "featurizationMethodParameters",
        featurizationMethodParameters
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.FeaturizationMethod
  ) extends zio.aws.forecast.model.FeaturizationMethod.ReadOnly {
    override val featurizationMethodName
        : zio.aws.forecast.model.FeaturizationMethodName =
      zio.aws.forecast.model.FeaturizationMethodName
        .wrap(impl.featurizationMethodName())
    override val featurizationMethodParameters
        : Optional[Map[ParameterKey, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.featurizationMethodParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.forecast.model.primitives.ParameterKey(
              key
            ) -> zio.aws.forecast.model.primitives.ParameterValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.FeaturizationMethod
  ): zio.aws.forecast.model.FeaturizationMethod.ReadOnly = new Wrapper(impl)
}
