package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAccuracyMetricsResponse(
    predictorEvaluationResults: Optional[
      Iterable[zio.aws.forecast.model.EvaluationResult]
    ] = Optional.Absent,
    isAutoPredictor: Optional[Boolean] = Optional.Absent,
    autoMLOverrideStrategy: Optional[
      zio.aws.forecast.model.AutoMLOverrideStrategy
    ] = Optional.Absent,
    optimizationMetric: Optional[zio.aws.forecast.model.OptimizationMetric] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsResponse = {
    import GetAccuracyMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsResponse
      .builder()
      .optionallyWith(
        predictorEvaluationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.predictorEvaluationResults)
      .optionallyWith(isAutoPredictor.map(value => value: java.lang.Boolean))(
        _.isAutoPredictor
      )
      .optionallyWith(autoMLOverrideStrategy.map(value => value.unwrap))(
        _.autoMLOverrideStrategy
      )
      .optionallyWith(optimizationMetric.map(value => value.unwrap))(
        _.optimizationMetric
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.GetAccuracyMetricsResponse.ReadOnly =
    zio.aws.forecast.model.GetAccuracyMetricsResponse.wrap(buildAwsValue())
}
object GetAccuracyMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.GetAccuracyMetricsResponse =
      zio.aws.forecast.model.GetAccuracyMetricsResponse(
        predictorEvaluationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isAutoPredictor.map(value => value),
        autoMLOverrideStrategy.map(value => value),
        optimizationMetric.map(value => value)
      )
    def predictorEvaluationResults
        : Optional[List[zio.aws.forecast.model.EvaluationResult.ReadOnly]]
    def isAutoPredictor: Optional[Boolean]
    def autoMLOverrideStrategy
        : Optional[zio.aws.forecast.model.AutoMLOverrideStrategy]
    def optimizationMetric: Optional[zio.aws.forecast.model.OptimizationMetric]
    def getPredictorEvaluationResults: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.EvaluationResult.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "predictorEvaluationResults",
      predictorEvaluationResults
    )
    def getIsAutoPredictor: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAutoPredictor", isAutoPredictor)
    def getAutoMLOverrideStrategy
        : ZIO[Any, AwsError, zio.aws.forecast.model.AutoMLOverrideStrategy] =
      AwsError.unwrapOptionField(
        "autoMLOverrideStrategy",
        autoMLOverrideStrategy
      )
    def getOptimizationMetric
        : ZIO[Any, AwsError, zio.aws.forecast.model.OptimizationMetric] =
      AwsError.unwrapOptionField("optimizationMetric", optimizationMetric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsResponse
  ) extends zio.aws.forecast.model.GetAccuracyMetricsResponse.ReadOnly {
    override val predictorEvaluationResults
        : Optional[List[zio.aws.forecast.model.EvaluationResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictorEvaluationResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.EvaluationResult.wrap(item)
          }.toList
        )
    override val isAutoPredictor: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAutoPredictor())
      .map(value => value: Boolean)
    override val autoMLOverrideStrategy
        : Optional[zio.aws.forecast.model.AutoMLOverrideStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLOverrideStrategy())
        .map(value => zio.aws.forecast.model.AutoMLOverrideStrategy.wrap(value))
    override val optimizationMetric
        : Optional[zio.aws.forecast.model.OptimizationMetric] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optimizationMetric())
        .map(value => zio.aws.forecast.model.OptimizationMetric.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsResponse
  ): zio.aws.forecast.model.GetAccuracyMetricsResponse.ReadOnly = new Wrapper(
    impl
  )
}
