package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListExplainabilityExportsResponse(
    explainabilityExports: Optional[
      Iterable[zio.aws.forecast.model.ExplainabilityExportSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse = {
    import ListExplainabilityExportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse
      .builder()
      .optionallyWith(
        explainabilityExports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.explainabilityExports)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.ListExplainabilityExportsResponse.ReadOnly =
    zio.aws.forecast.model.ListExplainabilityExportsResponse
      .wrap(buildAwsValue())
}
object ListExplainabilityExportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListExplainabilityExportsResponse =
      zio.aws.forecast.model.ListExplainabilityExportsResponse(
        explainabilityExports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def explainabilityExports: Optional[
      List[zio.aws.forecast.model.ExplainabilityExportSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getExplainabilityExports: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.ExplainabilityExportSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("explainabilityExports", explainabilityExports)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse
  ) extends zio.aws.forecast.model.ListExplainabilityExportsResponse.ReadOnly {
    override val explainabilityExports: Optional[
      List[zio.aws.forecast.model.ExplainabilityExportSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilityExports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.ExplainabilityExportSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse
  ): zio.aws.forecast.model.ListExplainabilityExportsResponse.ReadOnly =
    new Wrapper(impl)
}
