package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PredictorExecutionDetails(
    predictorExecutions: Optional[
      Iterable[zio.aws.forecast.model.PredictorExecution]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.PredictorExecutionDetails = {
    import PredictorExecutionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.PredictorExecutionDetails
      .builder()
      .optionallyWith(
        predictorExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.predictorExecutions)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.PredictorExecutionDetails.ReadOnly =
    zio.aws.forecast.model.PredictorExecutionDetails.wrap(buildAwsValue())
}
object PredictorExecutionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.PredictorExecutionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.PredictorExecutionDetails =
      zio.aws.forecast.model.PredictorExecutionDetails(
        predictorExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def predictorExecutions
        : Optional[List[zio.aws.forecast.model.PredictorExecution.ReadOnly]]
    def getPredictorExecutions: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.PredictorExecution.ReadOnly
    ]] = AwsError.unwrapOptionField("predictorExecutions", predictorExecutions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.PredictorExecutionDetails
  ) extends zio.aws.forecast.model.PredictorExecutionDetails.ReadOnly {
    override val predictorExecutions
        : Optional[List[zio.aws.forecast.model.PredictorExecution.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictorExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.PredictorExecution.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.PredictorExecutionDetails
  ): zio.aws.forecast.model.PredictorExecutionDetails.ReadOnly = new Wrapper(
    impl
  )
}
