package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Message,
  EvaluationState,
  Timestamp,
  Arn
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PredictorMonitorEvaluation(
    resourceArn: Optional[Arn] = Optional.Absent,
    monitorArn: Optional[Arn] = Optional.Absent,
    evaluationTime: Optional[Timestamp] = Optional.Absent,
    evaluationState: Optional[EvaluationState] = Optional.Absent,
    windowStartDatetime: Optional[Timestamp] = Optional.Absent,
    windowEndDatetime: Optional[Timestamp] = Optional.Absent,
    predictorEvent: Optional[zio.aws.forecast.model.PredictorEvent] =
      Optional.Absent,
    monitorDataSource: Optional[zio.aws.forecast.model.MonitorDataSource] =
      Optional.Absent,
    metricResults: Optional[Iterable[zio.aws.forecast.model.MetricResult]] =
      Optional.Absent,
    numItemsEvaluated: Optional[Long] = Optional.Absent,
    message: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.PredictorMonitorEvaluation = {
    import PredictorMonitorEvaluation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.PredictorMonitorEvaluation
      .builder()
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        monitorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.monitorArn)
      .optionallyWith(
        evaluationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.evaluationTime)
      .optionallyWith(
        evaluationState.map(value =>
          EvaluationState.unwrap(value): java.lang.String
        )
      )(_.evaluationState)
      .optionallyWith(
        windowStartDatetime.map(value => Timestamp.unwrap(value): Instant)
      )(_.windowStartDatetime)
      .optionallyWith(
        windowEndDatetime.map(value => Timestamp.unwrap(value): Instant)
      )(_.windowEndDatetime)
      .optionallyWith(predictorEvent.map(value => value.buildAwsValue()))(
        _.predictorEvent
      )
      .optionallyWith(monitorDataSource.map(value => value.buildAwsValue()))(
        _.monitorDataSource
      )
      .optionallyWith(
        metricResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricResults)
      .optionallyWith(numItemsEvaluated.map(value => value: java.lang.Long))(
        _.numItemsEvaluated
      )
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly =
    zio.aws.forecast.model.PredictorMonitorEvaluation.wrap(buildAwsValue())
}
object PredictorMonitorEvaluation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.PredictorMonitorEvaluation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.PredictorMonitorEvaluation =
      zio.aws.forecast.model.PredictorMonitorEvaluation(
        resourceArn.map(value => value),
        monitorArn.map(value => value),
        evaluationTime.map(value => value),
        evaluationState.map(value => value),
        windowStartDatetime.map(value => value),
        windowEndDatetime.map(value => value),
        predictorEvent.map(value => value.asEditable),
        monitorDataSource.map(value => value.asEditable),
        metricResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        numItemsEvaluated.map(value => value),
        message.map(value => value)
      )
    def resourceArn: Optional[Arn]
    def monitorArn: Optional[Arn]
    def evaluationTime: Optional[Timestamp]
    def evaluationState: Optional[EvaluationState]
    def windowStartDatetime: Optional[Timestamp]
    def windowEndDatetime: Optional[Timestamp]
    def predictorEvent: Optional[zio.aws.forecast.model.PredictorEvent.ReadOnly]
    def monitorDataSource
        : Optional[zio.aws.forecast.model.MonitorDataSource.ReadOnly]
    def metricResults
        : Optional[List[zio.aws.forecast.model.MetricResult.ReadOnly]]
    def numItemsEvaluated: Optional[Long]
    def message: Optional[Message]
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getMonitorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("monitorArn", monitorArn)
    def getEvaluationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("evaluationTime", evaluationTime)
    def getEvaluationState: ZIO[Any, AwsError, EvaluationState] =
      AwsError.unwrapOptionField("evaluationState", evaluationState)
    def getWindowStartDatetime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("windowStartDatetime", windowStartDatetime)
    def getWindowEndDatetime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("windowEndDatetime", windowEndDatetime)
    def getPredictorEvent
        : ZIO[Any, AwsError, zio.aws.forecast.model.PredictorEvent.ReadOnly] =
      AwsError.unwrapOptionField("predictorEvent", predictorEvent)
    def getMonitorDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.MonitorDataSource.ReadOnly
    ] = AwsError.unwrapOptionField("monitorDataSource", monitorDataSource)
    def getMetricResults: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.MetricResult.ReadOnly
    ]] = AwsError.unwrapOptionField("metricResults", metricResults)
    def getNumItemsEvaluated: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("numItemsEvaluated", numItemsEvaluated)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.PredictorMonitorEvaluation
  ) extends zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly {
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val monitorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.monitorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val evaluationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val evaluationState: Optional[EvaluationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationState())
        .map(value => zio.aws.forecast.model.primitives.EvaluationState(value))
    override val windowStartDatetime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowStartDatetime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val windowEndDatetime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.windowEndDatetime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val predictorEvent
        : Optional[zio.aws.forecast.model.PredictorEvent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictorEvent())
        .map(value => zio.aws.forecast.model.PredictorEvent.wrap(value))
    override val monitorDataSource
        : Optional[zio.aws.forecast.model.MonitorDataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitorDataSource())
        .map(value => zio.aws.forecast.model.MonitorDataSource.wrap(value))
    override val metricResults
        : Optional[List[zio.aws.forecast.model.MetricResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.MetricResult.wrap(item)
          }.toList
        )
    override val numItemsEvaluated: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.numItemsEvaluated())
      .map(value => value: Long)
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.PredictorMonitorEvaluation
  ): zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly = new Wrapper(
    impl
  )
}
