package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResumeResourceRequest(resourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ResumeResourceRequest = {
    import ResumeResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ResumeResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ResumeResourceRequest.ReadOnly =
    zio.aws.forecast.model.ResumeResourceRequest.wrap(buildAwsValue())
}
object ResumeResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ResumeResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ResumeResourceRequest =
      zio.aws.forecast.model.ResumeResourceRequest(resourceArn)
    def resourceArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ResumeResourceRequest
  ) extends zio.aws.forecast.model.ResumeResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ResumeResourceRequest
  ): zio.aws.forecast.model.ResumeResourceRequest.ReadOnly = new Wrapper(impl)
}
