package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{ErrorMessage, Status, Timestamp}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TestWindowSummary(
    testWindowStart: Optional[Timestamp] = Optional.Absent,
    testWindowEnd: Optional[Timestamp] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.TestWindowSummary = {
    import TestWindowSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.TestWindowSummary
      .builder()
      .optionallyWith(
        testWindowStart.map(value => Timestamp.unwrap(value): Instant)
      )(_.testWindowStart)
      .optionallyWith(
        testWindowEnd.map(value => Timestamp.unwrap(value): Instant)
      )(_.testWindowEnd)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.TestWindowSummary.ReadOnly =
    zio.aws.forecast.model.TestWindowSummary.wrap(buildAwsValue())
}
object TestWindowSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.TestWindowSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.TestWindowSummary =
      zio.aws.forecast.model.TestWindowSummary(
        testWindowStart.map(value => value),
        testWindowEnd.map(value => value),
        status.map(value => value),
        message.map(value => value)
      )
    def testWindowStart: Optional[Timestamp]
    def testWindowEnd: Optional[Timestamp]
    def status: Optional[Status]
    def message: Optional[ErrorMessage]
    def getTestWindowStart: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("testWindowStart", testWindowStart)
    def getTestWindowEnd: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("testWindowEnd", testWindowEnd)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.TestWindowSummary
  ) extends zio.aws.forecast.model.TestWindowSummary.ReadOnly {
    override val testWindowStart: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.testWindowStart())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val testWindowEnd: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.testWindowEnd())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.TestWindowSummary
  ): zio.aws.forecast.model.TestWindowSummary.ReadOnly = new Wrapper(impl)
}
