package zio.aws.forecast.model
import scala.jdk.CollectionConverters._
sealed trait TimePointGranularity {
  def unwrap
      : software.amazon.awssdk.services.forecast.model.TimePointGranularity
}
object TimePointGranularity {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.TimePointGranularity
  ): zio.aws.forecast.model.TimePointGranularity = value match {
    case software.amazon.awssdk.services.forecast.model.TimePointGranularity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.TimePointGranularity.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.forecast.model.TimePointGranularity.SPECIFIC =>
      val r = SPECIFIC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.forecast.model.TimePointGranularity {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.TimePointGranularity =
      software.amazon.awssdk.services.forecast.model.TimePointGranularity.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.forecast.model.TimePointGranularity {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.TimePointGranularity =
      software.amazon.awssdk.services.forecast.model.TimePointGranularity.ALL
  }
  case object SPECIFIC extends zio.aws.forecast.model.TimePointGranularity {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.TimePointGranularity =
      software.amazon.awssdk.services.forecast.model.TimePointGranularity.SPECIFIC
  }
}
