package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  LongArn,
  ErrorMessage,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class WhatIfForecastSummary(
    whatIfForecastArn: Optional[LongArn] = Optional.Absent,
    whatIfForecastName: Optional[Name] = Optional.Absent,
    whatIfAnalysisArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary = {
    import WhatIfForecastSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary
      .builder()
      .optionallyWith(
        whatIfForecastArn.map(value => LongArn.unwrap(value): java.lang.String)
      )(_.whatIfForecastArn)
      .optionallyWith(
        whatIfForecastName.map(value => Name.unwrap(value): java.lang.String)
      )(_.whatIfForecastName)
      .optionallyWith(
        whatIfAnalysisArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.whatIfAnalysisArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.WhatIfForecastSummary.ReadOnly =
    zio.aws.forecast.model.WhatIfForecastSummary.wrap(buildAwsValue())
}
object WhatIfForecastSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.WhatIfForecastSummary =
      zio.aws.forecast.model.WhatIfForecastSummary(
        whatIfForecastArn.map(value => value),
        whatIfForecastName.map(value => value),
        whatIfAnalysisArn.map(value => value),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def whatIfForecastArn: Optional[LongArn]
    def whatIfForecastName: Optional[Name]
    def whatIfAnalysisArn: Optional[Arn]
    def status: Optional[Status]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getWhatIfForecastArn: ZIO[Any, AwsError, LongArn] =
      AwsError.unwrapOptionField("whatIfForecastArn", whatIfForecastArn)
    def getWhatIfForecastName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("whatIfForecastName", whatIfForecastName)
    def getWhatIfAnalysisArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("whatIfAnalysisArn", whatIfAnalysisArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary
  ) extends zio.aws.forecast.model.WhatIfForecastSummary.ReadOnly {
    override val whatIfForecastArn: Optional[LongArn] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfForecastArn())
      .map(value => zio.aws.forecast.model.primitives.LongArn(value))
    override val whatIfForecastName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfForecastName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val whatIfAnalysisArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfAnalysisArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary
  ): zio.aws.forecast.model.WhatIfForecastSummary.ReadOnly = new Wrapper(impl)
}
