package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{Integer, Timestamp}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class WindowSummary(
    testWindowStart: Optional[Timestamp] = Optional.Absent,
    testWindowEnd: Optional[Timestamp] = Optional.Absent,
    itemCount: Optional[Integer] = Optional.Absent,
    evaluationType: Optional[zio.aws.forecast.model.EvaluationType] =
      Optional.Absent,
    metrics: Optional[zio.aws.forecast.model.Metrics] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.WindowSummary = {
    import WindowSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.WindowSummary
      .builder()
      .optionallyWith(
        testWindowStart.map(value => Timestamp.unwrap(value): Instant)
      )(_.testWindowStart)
      .optionallyWith(
        testWindowEnd.map(value => Timestamp.unwrap(value): Instant)
      )(_.testWindowEnd)
      .optionallyWith(itemCount.map(value => value: java.lang.Integer))(
        _.itemCount
      )
      .optionallyWith(evaluationType.map(value => value.unwrap))(
        _.evaluationType
      )
      .optionallyWith(metrics.map(value => value.buildAwsValue()))(_.metrics)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.WindowSummary.ReadOnly =
    zio.aws.forecast.model.WindowSummary.wrap(buildAwsValue())
}
object WindowSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.WindowSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.WindowSummary =
      zio.aws.forecast.model.WindowSummary(
        testWindowStart.map(value => value),
        testWindowEnd.map(value => value),
        itemCount.map(value => value),
        evaluationType.map(value => value),
        metrics.map(value => value.asEditable)
      )
    def testWindowStart: Optional[Timestamp]
    def testWindowEnd: Optional[Timestamp]
    def itemCount: Optional[Integer]
    def evaluationType: Optional[zio.aws.forecast.model.EvaluationType]
    def metrics: Optional[zio.aws.forecast.model.Metrics.ReadOnly]
    def getTestWindowStart: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("testWindowStart", testWindowStart)
    def getTestWindowEnd: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("testWindowEnd", testWindowEnd)
    def getItemCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getEvaluationType
        : ZIO[Any, AwsError, zio.aws.forecast.model.EvaluationType] =
      AwsError.unwrapOptionField("evaluationType", evaluationType)
    def getMetrics
        : ZIO[Any, AwsError, zio.aws.forecast.model.Metrics.ReadOnly] =
      AwsError.unwrapOptionField("metrics", metrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.WindowSummary
  ) extends zio.aws.forecast.model.WindowSummary.ReadOnly {
    override val testWindowStart: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.testWindowStart())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val testWindowEnd: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.testWindowEnd())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val itemCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => value: Integer)
    override val evaluationType
        : Optional[zio.aws.forecast.model.EvaluationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationType())
        .map(value => zio.aws.forecast.model.EvaluationType.wrap(value))
    override val metrics: Optional[zio.aws.forecast.model.Metrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value => zio.aws.forecast.model.Metrics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.WindowSummary
  ): zio.aws.forecast.model.WindowSummary.ReadOnly = new Wrapper(impl)
}
