package zio.aws.forecastquery
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.forecastquery.model.{
  QueryWhatIfForecastResponse,
  QueryWhatIfForecastRequest,
  QueryForecastResponse,
  QueryForecastRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.forecastquery.model.QueryWhatIfForecastResponse.ReadOnly
import software.amazon.awssdk.services.forecastquery.{
  ForecastqueryAsyncClientBuilder,
  ForecastqueryAsyncClient
}
import scala.jdk.CollectionConverters.*
trait Forecastquery extends AspectSupport[Forecastquery] {
  val api: ForecastqueryAsyncClient
  def queryForecast(
      request: zio.aws.forecastquery.model.QueryForecastRequest
  ): IO[AwsError, zio.aws.forecastquery.model.QueryForecastResponse.ReadOnly]
  def queryWhatIfForecast(
      request: zio.aws.forecastquery.model.QueryWhatIfForecastRequest
  ): IO[AwsError, ReadOnly]
}
object Forecastquery {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Forecastquery] = customized(
    identity
  )
  def customized(
      customization: ForecastqueryAsyncClientBuilder => ForecastqueryAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Forecastquery] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ForecastqueryAsyncClientBuilder => ForecastqueryAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Forecastquery] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ForecastqueryAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ForecastqueryAsyncClient, ForecastqueryAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ForecastqueryAsyncClient,
      ForecastqueryAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ForecastqueryImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ForecastqueryImpl[R](
      override val api: ForecastqueryAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Forecastquery
      with AwsServiceBase[R] {
    override val serviceName: String = "Forecastquery"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ForecastqueryImpl[R1] = new ForecastqueryImpl(api, newAspect, r)
    def queryForecast(
        request: zio.aws.forecastquery.model.QueryForecastRequest
    ): IO[
      AwsError,
      zio.aws.forecastquery.model.QueryForecastResponse.ReadOnly
    ] = asyncRequestResponse[QueryForecastRequest, QueryForecastResponse](
      "queryForecast",
      api.queryForecast
    )(request.buildAwsValue())
      .map(zio.aws.forecastquery.model.QueryForecastResponse.wrap)
      .provideEnvironment(r)
    def queryWhatIfForecast(
        request: zio.aws.forecastquery.model.QueryWhatIfForecastRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      QueryWhatIfForecastRequest,
      QueryWhatIfForecastResponse
    ]("queryWhatIfForecast", api.queryWhatIfForecast)(request.buildAwsValue())
      .map(zio.aws.forecastquery.model.QueryWhatIfForecastResponse.wrap)
      .provideEnvironment(r)
  }
  def queryForecast(
      request: zio.aws.forecastquery.model.QueryForecastRequest
  ): ZIO[
    zio.aws.forecastquery.Forecastquery,
    AwsError,
    zio.aws.forecastquery.model.QueryForecastResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.queryForecast(request))
  def queryWhatIfForecast(
      request: zio.aws.forecastquery.model.QueryWhatIfForecastRequest
  ): ZIO[zio.aws.forecastquery.Forecastquery, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.queryWhatIfForecast(request))
}
