package zio.aws.forecastquery
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.forecastquery.model.QueryWhatIfForecastResponse.ReadOnly
import zio.aws.forecastquery.model.{
  QueryWhatIfForecastRequest,
  QueryForecastRequest
}
import software.amazon.awssdk.services.forecastquery.ForecastqueryAsyncClient
object ForecastqueryMock extends Mock[Forecastquery] {
  object QueryForecast
      extends Effect[
        QueryForecastRequest,
        AwsError,
        zio.aws.forecastquery.model.QueryForecastResponse.ReadOnly
      ]
  object QueryWhatIfForecast
      extends Effect[QueryWhatIfForecastRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, Forecastquery] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Forecastquery] { rts =>
        zio.ZIO.succeed {
          new Forecastquery {
            val api: ForecastqueryAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Forecastquery = this
            def queryForecast(request: QueryForecastRequest): IO[
              AwsError,
              zio.aws.forecastquery.model.QueryForecastResponse.ReadOnly
            ] = proxy(QueryForecast, request)
            def queryWhatIfForecast(
                request: QueryWhatIfForecastRequest
            ): IO[AwsError, ReadOnly] = proxy(QueryWhatIfForecast, request)
          }
        }
      }
    }
  }
}
