package zio.aws.forecastquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.forecastquery.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class DataPoint(
    timestamp: Optional[Timestamp] = Optional.Absent,
    value: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecastquery.model.DataPoint = {
    import DataPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecastquery.model.DataPoint
      .builder()
      .optionallyWith(
        timestamp.map(value => Timestamp.unwrap(value): java.lang.String)
      )(_.timestamp)
      .optionallyWith(value.map(value => value: java.lang.Double))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.forecastquery.model.DataPoint.ReadOnly =
    zio.aws.forecastquery.model.DataPoint.wrap(buildAwsValue())
}
object DataPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecastquery.model.DataPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecastquery.model.DataPoint =
      zio.aws.forecastquery.model
        .DataPoint(timestamp.map(value => value), value.map(value => value))
    def timestamp: Optional[Timestamp]
    def value: Optional[Double]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecastquery.model.DataPoint
  ) extends zio.aws.forecastquery.model.DataPoint.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.forecastquery.model.primitives.Timestamp(value))
    override val value: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecastquery.model.DataPoint
  ): zio.aws.forecastquery.model.DataPoint.ReadOnly = new Wrapper(impl)
}
