package zio.aws.forecastquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.forecastquery.model.primitives.Statistic
import scala.jdk.CollectionConverters.*
final case class Forecast(
    predictions: Optional[
      Map[Statistic, Iterable[zio.aws.forecastquery.model.DataPoint]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecastquery.model.Forecast = {
    import Forecast.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecastquery.model.Forecast
      .builder()
      .optionallyWith(
        predictions.map(value =>
          value
            .map({ case (key, value) =>
              (Statistic.unwrap(key): java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.predictions)
      .build()
  }
  def asReadOnly: zio.aws.forecastquery.model.Forecast.ReadOnly =
    zio.aws.forecastquery.model.Forecast.wrap(buildAwsValue())
}
object Forecast {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecastquery.model.Forecast
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecastquery.model.Forecast =
      zio.aws.forecastquery.model.Forecast(
        predictions.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        )
      )
    def predictions: Optional[
      Map[Statistic, List[zio.aws.forecastquery.model.DataPoint.ReadOnly]]
    ]
    def getPredictions: ZIO[Any, AwsError, Map[Statistic, List[
      zio.aws.forecastquery.model.DataPoint.ReadOnly
    ]]] = AwsError.unwrapOptionField("predictions", predictions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecastquery.model.Forecast
  ) extends zio.aws.forecastquery.model.Forecast.ReadOnly {
    override val predictions: Optional[
      Map[Statistic, List[zio.aws.forecastquery.model.DataPoint.ReadOnly]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.predictions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.forecastquery.model.primitives
              .Statistic(key) -> value.asScala.map { item =>
              zio.aws.forecastquery.model.DataPoint.wrap(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecastquery.model.Forecast
  ): zio.aws.forecastquery.model.Forecast.ReadOnly = new Wrapper(impl)
}
