package zio.aws.forecastquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.forecastquery.model.primitives.{
  NextToken,
  AttributeName,
  Arn,
  DateTime,
  AttributeValue
}
import scala.jdk.CollectionConverters.*
final case class QueryForecastRequest(
    forecastArn: Arn,
    startDate: Optional[DateTime] = Optional.Absent,
    endDate: Optional[DateTime] = Optional.Absent,
    filters: Map[AttributeName, AttributeValue],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecastquery.model.QueryForecastRequest = {
    import QueryForecastRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecastquery.model.QueryForecastRequest
      .builder()
      .forecastArn(Arn.unwrap(forecastArn): java.lang.String)
      .optionallyWith(
        startDate.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.startDate)
      .optionallyWith(
        endDate.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.endDate)
      .filters(
        filters
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.forecastquery.model.QueryForecastRequest.ReadOnly =
    zio.aws.forecastquery.model.QueryForecastRequest.wrap(buildAwsValue())
}
object QueryForecastRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecastquery.model.QueryForecastRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecastquery.model.QueryForecastRequest =
      zio.aws.forecastquery.model.QueryForecastRequest(
        forecastArn,
        startDate.map(value => value),
        endDate.map(value => value),
        filters,
        nextToken.map(value => value)
      )
    def forecastArn: Arn
    def startDate: Optional[DateTime]
    def endDate: Optional[DateTime]
    def filters: Map[AttributeName, AttributeValue]
    def nextToken: Optional[NextToken]
    def getForecastArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(forecastArn)
    def getStartDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getFilters: ZIO[Any, Nothing, Map[AttributeName, AttributeValue]] =
      ZIO.succeed(filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecastquery.model.QueryForecastRequest
  ) extends zio.aws.forecastquery.model.QueryForecastRequest.ReadOnly {
    override val forecastArn: Arn =
      zio.aws.forecastquery.model.primitives.Arn(impl.forecastArn())
    override val startDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.forecastquery.model.primitives.DateTime(value))
    override val endDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.forecastquery.model.primitives.DateTime(value))
    override val filters: Map[AttributeName, AttributeValue] = impl
      .filters()
      .asScala
      .map({ case (key, value) =>
        zio.aws.forecastquery.model.primitives.AttributeName(
          key
        ) -> zio.aws.forecastquery.model.primitives.AttributeValue(value)
      })
      .toMap
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecastquery.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecastquery.model.QueryForecastRequest
  ): zio.aws.forecastquery.model.QueryForecastRequest.ReadOnly = new Wrapper(
    impl
  )
}
