package zio.aws.forecastquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryForecastResponse(
    forecast: Optional[zio.aws.forecastquery.model.Forecast] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecastquery.model.QueryForecastResponse = {
    import QueryForecastResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecastquery.model.QueryForecastResponse
      .builder()
      .optionallyWith(forecast.map(value => value.buildAwsValue()))(_.forecast)
      .build()
  }
  def asReadOnly: zio.aws.forecastquery.model.QueryForecastResponse.ReadOnly =
    zio.aws.forecastquery.model.QueryForecastResponse.wrap(buildAwsValue())
}
object QueryForecastResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecastquery.model.QueryForecastResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecastquery.model.QueryForecastResponse =
      zio.aws.forecastquery.model
        .QueryForecastResponse(forecast.map(value => value.asEditable))
    def forecast: Optional[zio.aws.forecastquery.model.Forecast.ReadOnly]
    def getForecast
        : ZIO[Any, AwsError, zio.aws.forecastquery.model.Forecast.ReadOnly] =
      AwsError.unwrapOptionField("forecast", forecast)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecastquery.model.QueryForecastResponse
  ) extends zio.aws.forecastquery.model.QueryForecastResponse.ReadOnly {
    override val forecast
        : Optional[zio.aws.forecastquery.model.Forecast.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecast())
        .map(value => zio.aws.forecastquery.model.Forecast.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecastquery.model.QueryForecastResponse
  ): zio.aws.forecastquery.model.QueryForecastResponse.ReadOnly = new Wrapper(
    impl
  )
}
