package zio.aws.forecastquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.forecastquery.model.primitives.{
  LongArn,
  NextToken,
  AttributeName,
  DateTime,
  AttributeValue
}
import scala.jdk.CollectionConverters.*
final case class QueryWhatIfForecastRequest(
    whatIfForecastArn: LongArn,
    startDate: Optional[DateTime] = Optional.Absent,
    endDate: Optional[DateTime] = Optional.Absent,
    filters: Map[AttributeName, AttributeValue],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastRequest = {
    import QueryWhatIfForecastRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastRequest
      .builder()
      .whatIfForecastArn(LongArn.unwrap(whatIfForecastArn): java.lang.String)
      .optionallyWith(
        startDate.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.startDate)
      .optionallyWith(
        endDate.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.endDate)
      .filters(
        filters
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.forecastquery.model.QueryWhatIfForecastRequest.ReadOnly =
    zio.aws.forecastquery.model.QueryWhatIfForecastRequest.wrap(buildAwsValue())
}
object QueryWhatIfForecastRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecastquery.model.QueryWhatIfForecastRequest =
      zio.aws.forecastquery.model.QueryWhatIfForecastRequest(
        whatIfForecastArn,
        startDate.map(value => value),
        endDate.map(value => value),
        filters,
        nextToken.map(value => value)
      )
    def whatIfForecastArn: LongArn
    def startDate: Optional[DateTime]
    def endDate: Optional[DateTime]
    def filters: Map[AttributeName, AttributeValue]
    def nextToken: Optional[NextToken]
    def getWhatIfForecastArn: ZIO[Any, Nothing, LongArn] =
      ZIO.succeed(whatIfForecastArn)
    def getStartDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getFilters: ZIO[Any, Nothing, Map[AttributeName, AttributeValue]] =
      ZIO.succeed(filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastRequest
  ) extends zio.aws.forecastquery.model.QueryWhatIfForecastRequest.ReadOnly {
    override val whatIfForecastArn: LongArn =
      zio.aws.forecastquery.model.primitives.LongArn(impl.whatIfForecastArn())
    override val startDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.forecastquery.model.primitives.DateTime(value))
    override val endDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.forecastquery.model.primitives.DateTime(value))
    override val filters: Map[AttributeName, AttributeValue] = impl
      .filters()
      .asScala
      .map({ case (key, value) =>
        zio.aws.forecastquery.model.primitives.AttributeName(
          key
        ) -> zio.aws.forecastquery.model.primitives.AttributeValue(value)
      })
      .toMap
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecastquery.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastRequest
  ): zio.aws.forecastquery.model.QueryWhatIfForecastRequest.ReadOnly =
    new Wrapper(impl)
}
