package zio.aws.forecastquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryWhatIfForecastResponse(
    forecast: Optional[zio.aws.forecastquery.model.Forecast] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastResponse = {
    import QueryWhatIfForecastResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastResponse
      .builder()
      .optionallyWith(forecast.map(value => value.buildAwsValue()))(_.forecast)
      .build()
  }
  def asReadOnly
      : zio.aws.forecastquery.model.QueryWhatIfForecastResponse.ReadOnly =
    zio.aws.forecastquery.model.QueryWhatIfForecastResponse
      .wrap(buildAwsValue())
}
object QueryWhatIfForecastResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecastquery.model.QueryWhatIfForecastResponse =
      zio.aws.forecastquery.model
        .QueryWhatIfForecastResponse(forecast.map(value => value.asEditable))
    def forecast: Optional[zio.aws.forecastquery.model.Forecast.ReadOnly]
    def getForecast
        : ZIO[Any, AwsError, zio.aws.forecastquery.model.Forecast.ReadOnly] =
      AwsError.unwrapOptionField("forecast", forecast)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastResponse
  ) extends zio.aws.forecastquery.model.QueryWhatIfForecastResponse.ReadOnly {
    override val forecast
        : Optional[zio.aws.forecastquery.model.Forecast.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecast())
        .map(value => zio.aws.forecastquery.model.Forecast.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecastquery.model.QueryWhatIfForecastResponse
  ): zio.aws.forecastquery.model.QueryWhatIfForecastResponse.ReadOnly =
    new Wrapper(impl)
}
