package zio.aws.forecastquery
import zio.prelude.Subtype
import zio.aws.forecastquery.model.primitives.{
  Statistic,
  AttributeValue,
  AttributeName
}
import zio.aws.forecastquery.model.primitives.Arn.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.forecastquery.model.primitives.Arn.Type
    object AttributeName extends Subtype[String]
    type AttributeName =
      zio.aws.forecastquery.model.primitives.AttributeName.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue =
      zio.aws.forecastquery.model.primitives.AttributeValue.Type
    object DateTime extends Subtype[String]
    type DateTime = zio.aws.forecastquery.model.primitives.DateTime.Type
    object LongArn extends Subtype[String]
    type LongArn = zio.aws.forecastquery.model.primitives.LongArn.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.forecastquery.model.primitives.NextToken.Type
    object Statistic extends Subtype[String]
    type Statistic = zio.aws.forecastquery.model.primitives.Statistic.Type
    object Timestamp extends Subtype[String]
    type Timestamp = zio.aws.forecastquery.model.primitives.Timestamp.Type
  }
  type Filters = Map[AttributeName, AttributeValue]
  type Predictions =
    Map[Statistic, Iterable[zio.aws.forecastquery.model.DataPoint]]
  type TimeSeries = List[zio.aws.forecastquery.model.DataPoint]
}
