package zio.aws.fsx
import zio.aws.fsx.model.DescribeSnapshotsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.fsx.{
  FSxAsyncClientBuilder,
  FSxAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.aws.fsx.model.{
  DisassociateFileSystemAliasesRequest,
  UpdateStorageVirtualMachineRequest,
  DeleteFileSystemRequest,
  CreateBackupRequest,
  AssociateFileSystemAliasesRequest,
  DescribeSnapshotsRequest,
  DeleteVolumeRequest,
  DeleteSnapshotRequest,
  CancelDataRepositoryTaskRequest,
  DescribeFileSystemsRequest,
  DescribeDataRepositoryAssociationsRequest,
  UpdateSnapshotRequest,
  ListTagsForResourceRequest,
  UpdateVolumeRequest,
  DeleteStorageVirtualMachineRequest,
  RestoreVolumeFromSnapshotRequest,
  DescribeVolumesRequest,
  CopyBackupRequest,
  CreateDataRepositoryTaskRequest,
  CreateDataRepositoryAssociationRequest,
  DescribeFileSystemAliasesRequest,
  CreateFileSystemFromBackupRequest,
  CreateVolumeRequest,
  DeleteBackupRequest,
  DescribeDataRepositoryTasksRequest,
  UntagResourceRequest,
  UpdateFileSystemRequest,
  CreateFileSystemRequest,
  CreateSnapshotRequest,
  ReleaseFileSystemNfsV3LocksRequest,
  DescribeBackupsRequest,
  CreateStorageVirtualMachineRequest,
  DescribeStorageVirtualMachinesRequest,
  CreateVolumeFromBackupRequest,
  UpdateDataRepositoryAssociationRequest,
  DeleteDataRepositoryAssociationRequest,
  TagResourceRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.fsx.model.{
  DescribeStorageVirtualMachinesResponse,
  UpdateDataRepositoryAssociationResponse,
  DescribeDataRepositoryAssociationsResponse,
  DescribeSnapshotsResponse,
  Backup,
  UpdateVolumeResponse,
  DataRepositoryTask,
  AssociateFileSystemAliasesResponse,
  CreateDataRepositoryTaskResponse,
  RestoreVolumeFromSnapshotResponse,
  DisassociateFileSystemAliasesResponse,
  CreateDataRepositoryAssociationResponse,
  Tag,
  DataRepositoryAssociation,
  UpdateFileSystemResponse,
  DeleteStorageVirtualMachineResponse,
  Snapshot,
  DeleteVolumeResponse,
  ListTagsForResourceResponse,
  StorageVirtualMachine,
  ReleaseFileSystemNfsV3LocksResponse,
  UntagResourceResponse,
  UpdateSnapshotResponse,
  DescribeBackupsResponse,
  CreateFileSystemFromBackupResponse,
  DeleteFileSystemResponse,
  DescribeFileSystemAliasesResponse,
  CreateFileSystemResponse,
  DescribeDataRepositoryTasksResponse,
  CancelDataRepositoryTaskResponse,
  CreateVolumeFromBackupResponse,
  FileSystem,
  DescribeVolumesResponse,
  CreateBackupResponse,
  UpdateStorageVirtualMachineResponse,
  CreateVolumeResponse,
  DescribeFileSystemsResponse,
  DeleteDataRepositoryAssociationResponse,
  DeleteBackupResponse,
  Volume,
  TagResourceResponse,
  CreateSnapshotResponse,
  DeleteSnapshotResponse,
  CreateStorageVirtualMachineResponse,
  Alias,
  CopyBackupResponse
}
import scala.jdk.CollectionConverters._
trait FSx extends AspectSupport[FSx] {
  val api: FSxAsyncClient
  def disassociateFileSystemAliases(
      request: DisassociateFileSystemAliasesRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.DisassociateFileSystemAliasesResponse.ReadOnly
  ]
  def deleteDataRepositoryAssociation(
      request: DeleteDataRepositoryAssociationRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse.ReadOnly
  ]
  def createFileSystemFromBackup(
      request: CreateFileSystemFromBackupRequest
  ): IO[AwsError, zio.aws.fsx.model.CreateFileSystemFromBackupResponse.ReadOnly]
  def associateFileSystemAliases(
      request: AssociateFileSystemAliasesRequest
  ): IO[AwsError, zio.aws.fsx.model.AssociateFileSystemAliasesResponse.ReadOnly]
  def createDataRepositoryAssociation(
      request: CreateDataRepositoryAssociationRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.CreateDataRepositoryAssociationResponse.ReadOnly
  ]
  def updateFileSystem(
      request: UpdateFileSystemRequest
  ): IO[AwsError, zio.aws.fsx.model.UpdateFileSystemResponse.ReadOnly]
  def describeStorageVirtualMachines(
      request: DescribeStorageVirtualMachinesRequest
  ): ZStream[Any, AwsError, zio.aws.fsx.model.StorageVirtualMachine.ReadOnly]
  def describeStorageVirtualMachinesPaginated(
      request: DescribeStorageVirtualMachinesRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse.ReadOnly
  ]
  def createBackup(
      request: CreateBackupRequest
  ): IO[AwsError, zio.aws.fsx.model.CreateBackupResponse.ReadOnly]
  def restoreVolumeFromSnapshot(
      request: RestoreVolumeFromSnapshotRequest
  ): IO[AwsError, zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly]
  def describeBackups(
      request: DescribeBackupsRequest
  ): ZStream[Any, AwsError, zio.aws.fsx.model.Backup.ReadOnly]
  def describeBackupsPaginated(
      request: DescribeBackupsRequest
  ): IO[AwsError, zio.aws.fsx.model.DescribeBackupsResponse.ReadOnly]
  def describeFileSystemAliases(
      request: DescribeFileSystemAliasesRequest
  ): ZStream[Any, AwsError, zio.aws.fsx.model.Alias.ReadOnly]
  def describeFileSystemAliasesPaginated(
      request: DescribeFileSystemAliasesRequest
  ): IO[AwsError, zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly]
  def updateDataRepositoryAssociation(
      request: UpdateDataRepositoryAssociationRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse.ReadOnly
  ]
  def releaseFileSystemNfsV3Locks(
      request: ReleaseFileSystemNfsV3LocksRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse.ReadOnly
  ]
  def createStorageVirtualMachine(
      request: CreateStorageVirtualMachineRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.CreateStorageVirtualMachineResponse.ReadOnly
  ]
  def describeVolumes(
      request: DescribeVolumesRequest
  ): ZStream[Any, AwsError, zio.aws.fsx.model.Volume.ReadOnly]
  def describeVolumesPaginated(
      request: DescribeVolumesRequest
  ): IO[AwsError, zio.aws.fsx.model.DescribeVolumesResponse.ReadOnly]
  def createVolume(
      request: CreateVolumeRequest
  ): IO[AwsError, zio.aws.fsx.model.CreateVolumeResponse.ReadOnly]
  def deleteSnapshot(
      request: DeleteSnapshotRequest
  ): IO[AwsError, zio.aws.fsx.model.DeleteSnapshotResponse.ReadOnly]
  def copyBackup(
      request: CopyBackupRequest
  ): IO[AwsError, zio.aws.fsx.model.CopyBackupResponse.ReadOnly]
  def deleteStorageVirtualMachine(
      request: DeleteStorageVirtualMachineRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.DeleteStorageVirtualMachineResponse.ReadOnly
  ]
  def updateVolume(
      request: UpdateVolumeRequest
  ): IO[AwsError, zio.aws.fsx.model.UpdateVolumeResponse.ReadOnly]
  def describeDataRepositoryAssociations(
      request: DescribeDataRepositoryAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly
  ]
  def describeDataRepositoryAssociationsPaginated(
      request: DescribeDataRepositoryAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly
  ]
  def createFileSystem(
      request: CreateFileSystemRequest
  ): IO[AwsError, zio.aws.fsx.model.CreateFileSystemResponse.ReadOnly]
  def describeDataRepositoryTasks(
      request: DescribeDataRepositoryTasksRequest
  ): ZStream[Any, AwsError, zio.aws.fsx.model.DataRepositoryTask.ReadOnly]
  def describeDataRepositoryTasksPaginated(
      request: DescribeDataRepositoryTasksRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.DescribeDataRepositoryTasksResponse.ReadOnly
  ]
  def updateSnapshot(
      request: UpdateSnapshotRequest
  ): IO[AwsError, zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.fsx.model.UntagResourceResponse.ReadOnly]
  def describeFileSystems(
      request: DescribeFileSystemsRequest
  ): ZStream[Any, AwsError, zio.aws.fsx.model.FileSystem.ReadOnly]
  def describeFileSystemsPaginated(
      request: DescribeFileSystemsRequest
  ): IO[AwsError, zio.aws.fsx.model.DescribeFileSystemsResponse.ReadOnly]
  def createDataRepositoryTask(
      request: CreateDataRepositoryTaskRequest
  ): IO[AwsError, zio.aws.fsx.model.CreateDataRepositoryTaskResponse.ReadOnly]
  def deleteFileSystem(
      request: DeleteFileSystemRequest
  ): IO[AwsError, zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly]
  def createVolumeFromBackup(
      request: CreateVolumeFromBackupRequest
  ): IO[AwsError, zio.aws.fsx.model.CreateVolumeFromBackupResponse.ReadOnly]
  def cancelDataRepositoryTask(
      request: CancelDataRepositoryTaskRequest
  ): IO[AwsError, zio.aws.fsx.model.CancelDataRepositoryTaskResponse.ReadOnly]
  def describeSnapshots(
      request: DescribeSnapshotsRequest
  ): ZStream[Any, AwsError, zio.aws.fsx.model.Snapshot.ReadOnly]
  def describeSnapshotsPaginated(
      request: DescribeSnapshotsRequest
  ): IO[AwsError, ReadOnly]
  def deleteBackup(
      request: DeleteBackupRequest
  ): IO[AwsError, zio.aws.fsx.model.DeleteBackupResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.fsx.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.fsx.model.ListTagsForResourceResponse.ReadOnly]
  def deleteVolume(
      request: DeleteVolumeRequest
  ): IO[AwsError, zio.aws.fsx.model.DeleteVolumeResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.fsx.model.TagResourceResponse.ReadOnly]
  def updateStorageVirtualMachine(
      request: UpdateStorageVirtualMachineRequest
  ): IO[
    AwsError,
    zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly
  ]
  def createSnapshot(
      request: CreateSnapshotRequest
  ): IO[AwsError, zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly]
}
object FSx {
  val live: ZLayer[AwsConfig, java.lang.Throwable, FSx] = customized(identity)
  def customized(
      customization: FSxAsyncClientBuilder => FSxAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, FSx] = managed(
    customization
  ).toLayer
  def managed(
      customization: FSxAsyncClientBuilder => FSxAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, FSx] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = FSxAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[FSxAsyncClient, FSxAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[FSxAsyncClient, FSxAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new FSxImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class FSxImpl[R](
      override val api: FSxAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends FSx
      with AwsServiceBase[R] {
    override val serviceName: String = "FSx"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): FSxImpl[R1] = new FSxImpl(api, newAspect, r)
    def disassociateFileSystemAliases(
        request: DisassociateFileSystemAliasesRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.DisassociateFileSystemAliasesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.DisassociateFileSystemAliasesRequest,
      DisassociateFileSystemAliasesResponse
    ]("disassociateFileSystemAliases", api.disassociateFileSystemAliases)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.DisassociateFileSystemAliasesResponse.wrap)
      .provideEnvironment(r)
    def deleteDataRepositoryAssociation(
        request: DeleteDataRepositoryAssociationRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest,
      DeleteDataRepositoryAssociationResponse
    ]("deleteDataRepositoryAssociation", api.deleteDataRepositoryAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse.wrap)
      .provideEnvironment(r)
    def createFileSystemFromBackup(
        request: CreateFileSystemFromBackupRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.CreateFileSystemFromBackupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.CreateFileSystemFromBackupRequest,
      CreateFileSystemFromBackupResponse
    ]("createFileSystemFromBackup", api.createFileSystemFromBackup)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.CreateFileSystemFromBackupResponse.wrap)
      .provideEnvironment(r)
    def associateFileSystemAliases(
        request: AssociateFileSystemAliasesRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.AssociateFileSystemAliasesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesRequest,
      AssociateFileSystemAliasesResponse
    ]("associateFileSystemAliases", api.associateFileSystemAliases)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.AssociateFileSystemAliasesResponse.wrap)
      .provideEnvironment(r)
    def createDataRepositoryAssociation(
        request: CreateDataRepositoryAssociationRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.CreateDataRepositoryAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest,
      CreateDataRepositoryAssociationResponse
    ]("createDataRepositoryAssociation", api.createDataRepositoryAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.CreateDataRepositoryAssociationResponse.wrap)
      .provideEnvironment(r)
    def updateFileSystem(
        request: UpdateFileSystemRequest
    ): IO[AwsError, zio.aws.fsx.model.UpdateFileSystemResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.UpdateFileSystemRequest,
        UpdateFileSystemResponse
      ]("updateFileSystem", api.updateFileSystem)(request.buildAwsValue())
        .map(zio.aws.fsx.model.UpdateFileSystemResponse.wrap)
        .provideEnvironment(r)
    def describeStorageVirtualMachines(
        request: DescribeStorageVirtualMachinesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.fsx.model.StorageVirtualMachine.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest,
      DescribeStorageVirtualMachinesResponse,
      StorageVirtualMachine
    ](
      "describeStorageVirtualMachines",
      api.describeStorageVirtualMachines,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.storageVirtualMachines().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.fsx.model.StorageVirtualMachine.wrap(item))
      .provideEnvironment(r)
    def describeStorageVirtualMachinesPaginated(
        request: DescribeStorageVirtualMachinesRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest,
      DescribeStorageVirtualMachinesResponse
    ]("describeStorageVirtualMachines", api.describeStorageVirtualMachines)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse.wrap)
      .provideEnvironment(r)
    def createBackup(
        request: CreateBackupRequest
    ): IO[AwsError, zio.aws.fsx.model.CreateBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.CreateBackupRequest,
        CreateBackupResponse
      ]("createBackup", api.createBackup)(request.buildAwsValue())
        .map(zio.aws.fsx.model.CreateBackupResponse.wrap)
        .provideEnvironment(r)
    def restoreVolumeFromSnapshot(
        request: RestoreVolumeFromSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.RestoreVolumeFromSnapshotRequest,
      RestoreVolumeFromSnapshotResponse
    ]("restoreVolumeFromSnapshot", api.restoreVolumeFromSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.wrap)
      .provideEnvironment(r)
    def describeBackups(
        request: DescribeBackupsRequest
    ): ZStream[Any, AwsError, zio.aws.fsx.model.Backup.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest,
        DescribeBackupsResponse,
        Backup
      ](
        "describeBackups",
        api.describeBackups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.backups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.fsx.model.Backup.wrap(item))
        .provideEnvironment(r)
    def describeBackupsPaginated(
        request: DescribeBackupsRequest
    ): IO[AwsError, zio.aws.fsx.model.DescribeBackupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest,
        DescribeBackupsResponse
      ]("describeBackups", api.describeBackups)(request.buildAwsValue())
        .map(zio.aws.fsx.model.DescribeBackupsResponse.wrap)
        .provideEnvironment(r)
    def describeFileSystemAliases(
        request: DescribeFileSystemAliasesRequest
    ): ZStream[Any, AwsError, zio.aws.fsx.model.Alias.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest,
        DescribeFileSystemAliasesResponse,
        Alias
      ](
        "describeFileSystemAliases",
        api.describeFileSystemAliases,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.aliases().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.fsx.model.Alias.wrap(item))
        .provideEnvironment(r)
    def describeFileSystemAliasesPaginated(
        request: DescribeFileSystemAliasesRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.DescribeFileSystemAliasesRequest,
      DescribeFileSystemAliasesResponse
    ]("describeFileSystemAliases", api.describeFileSystemAliases)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.DescribeFileSystemAliasesResponse.wrap)
      .provideEnvironment(r)
    def updateDataRepositoryAssociation(
        request: UpdateDataRepositoryAssociationRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest,
      UpdateDataRepositoryAssociationResponse
    ]("updateDataRepositoryAssociation", api.updateDataRepositoryAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse.wrap)
      .provideEnvironment(r)
    def releaseFileSystemNfsV3Locks(
        request: ReleaseFileSystemNfsV3LocksRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest,
      ReleaseFileSystemNfsV3LocksResponse
    ]("releaseFileSystemNfsV3Locks", api.releaseFileSystemNfsV3Locks)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse.wrap)
      .provideEnvironment(r)
    def createStorageVirtualMachine(
        request: CreateStorageVirtualMachineRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.CreateStorageVirtualMachineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineRequest,
      CreateStorageVirtualMachineResponse
    ]("createStorageVirtualMachine", api.createStorageVirtualMachine)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.CreateStorageVirtualMachineResponse.wrap)
      .provideEnvironment(r)
    def describeVolumes(
        request: DescribeVolumesRequest
    ): ZStream[Any, AwsError, zio.aws.fsx.model.Volume.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest,
        DescribeVolumesResponse,
        Volume
      ](
        "describeVolumes",
        api.describeVolumes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.volumes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.fsx.model.Volume.wrap(item))
        .provideEnvironment(r)
    def describeVolumesPaginated(
        request: DescribeVolumesRequest
    ): IO[AwsError, zio.aws.fsx.model.DescribeVolumesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest,
        DescribeVolumesResponse
      ]("describeVolumes", api.describeVolumes)(request.buildAwsValue())
        .map(zio.aws.fsx.model.DescribeVolumesResponse.wrap)
        .provideEnvironment(r)
    def createVolume(
        request: CreateVolumeRequest
    ): IO[AwsError, zio.aws.fsx.model.CreateVolumeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.CreateVolumeRequest,
        CreateVolumeResponse
      ]("createVolume", api.createVolume)(request.buildAwsValue())
        .map(zio.aws.fsx.model.CreateVolumeResponse.wrap)
        .provideEnvironment(r)
    def deleteSnapshot(
        request: DeleteSnapshotRequest
    ): IO[AwsError, zio.aws.fsx.model.DeleteSnapshotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.DeleteSnapshotRequest,
        DeleteSnapshotResponse
      ]("deleteSnapshot", api.deleteSnapshot)(request.buildAwsValue())
        .map(zio.aws.fsx.model.DeleteSnapshotResponse.wrap)
        .provideEnvironment(r)
    def copyBackup(
        request: CopyBackupRequest
    ): IO[AwsError, zio.aws.fsx.model.CopyBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.CopyBackupRequest,
        CopyBackupResponse
      ]("copyBackup", api.copyBackup)(request.buildAwsValue())
        .map(zio.aws.fsx.model.CopyBackupResponse.wrap)
        .provideEnvironment(r)
    def deleteStorageVirtualMachine(
        request: DeleteStorageVirtualMachineRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.DeleteStorageVirtualMachineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.DeleteStorageVirtualMachineRequest,
      DeleteStorageVirtualMachineResponse
    ]("deleteStorageVirtualMachine", api.deleteStorageVirtualMachine)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.DeleteStorageVirtualMachineResponse.wrap)
      .provideEnvironment(r)
    def updateVolume(
        request: UpdateVolumeRequest
    ): IO[AwsError, zio.aws.fsx.model.UpdateVolumeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.UpdateVolumeRequest,
        UpdateVolumeResponse
      ]("updateVolume", api.updateVolume)(request.buildAwsValue())
        .map(zio.aws.fsx.model.UpdateVolumeResponse.wrap)
        .provideEnvironment(r)
    def describeDataRepositoryAssociations(
        request: DescribeDataRepositoryAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest,
      DescribeDataRepositoryAssociationsResponse,
      DataRepositoryAssociation
    ](
      "describeDataRepositoryAssociations",
      api.describeDataRepositoryAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.associations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.fsx.model.DataRepositoryAssociation.wrap(item))
      .provideEnvironment(r)
    def describeDataRepositoryAssociationsPaginated(
        request: DescribeDataRepositoryAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest,
      DescribeDataRepositoryAssociationsResponse
    ](
      "describeDataRepositoryAssociations",
      api.describeDataRepositoryAssociations
    )(request.buildAwsValue())
      .map(zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.wrap)
      .provideEnvironment(r)
    def createFileSystem(
        request: CreateFileSystemRequest
    ): IO[AwsError, zio.aws.fsx.model.CreateFileSystemResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest,
        CreateFileSystemResponse
      ]("createFileSystem", api.createFileSystem)(request.buildAwsValue())
        .map(zio.aws.fsx.model.CreateFileSystemResponse.wrap)
        .provideEnvironment(r)
    def describeDataRepositoryTasks(
        request: DescribeDataRepositoryTasksRequest
    ): ZStream[Any, AwsError, zio.aws.fsx.model.DataRepositoryTask.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest,
        DescribeDataRepositoryTasksResponse,
        DataRepositoryTask
      ](
        "describeDataRepositoryTasks",
        api.describeDataRepositoryTasks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.dataRepositoryTasks().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.fsx.model.DataRepositoryTask.wrap(item))
        .provideEnvironment(r)
    def describeDataRepositoryTasksPaginated(
        request: DescribeDataRepositoryTasksRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.DescribeDataRepositoryTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryTasksRequest,
      DescribeDataRepositoryTasksResponse
    ]("describeDataRepositoryTasks", api.describeDataRepositoryTasks)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.DescribeDataRepositoryTasksResponse.wrap)
      .provideEnvironment(r)
    def updateSnapshot(
        request: UpdateSnapshotRequest
    ): IO[AwsError, zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.UpdateSnapshotRequest,
        UpdateSnapshotResponse
      ]("updateSnapshot", api.updateSnapshot)(request.buildAwsValue())
        .map(zio.aws.fsx.model.UpdateSnapshotResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.fsx.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.fsx.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeFileSystems(
        request: DescribeFileSystemsRequest
    ): ZStream[Any, AwsError, zio.aws.fsx.model.FileSystem.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest,
        DescribeFileSystemsResponse,
        FileSystem
      ](
        "describeFileSystems",
        api.describeFileSystems,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.fileSystems().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.fsx.model.FileSystem.wrap(item))
        .provideEnvironment(r)
    def describeFileSystemsPaginated(
        request: DescribeFileSystemsRequest
    ): IO[AwsError, zio.aws.fsx.model.DescribeFileSystemsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.DescribeFileSystemsRequest,
        DescribeFileSystemsResponse
      ]("describeFileSystems", api.describeFileSystems)(request.buildAwsValue())
        .map(zio.aws.fsx.model.DescribeFileSystemsResponse.wrap)
        .provideEnvironment(r)
    def createDataRepositoryTask(request: CreateDataRepositoryTaskRequest): IO[
      AwsError,
      zio.aws.fsx.model.CreateDataRepositoryTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskRequest,
      CreateDataRepositoryTaskResponse
    ]("createDataRepositoryTask", api.createDataRepositoryTask)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.CreateDataRepositoryTaskResponse.wrap)
      .provideEnvironment(r)
    def deleteFileSystem(
        request: DeleteFileSystemRequest
    ): IO[AwsError, zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.DeleteFileSystemRequest,
        DeleteFileSystemResponse
      ]("deleteFileSystem", api.deleteFileSystem)(request.buildAwsValue())
        .map(zio.aws.fsx.model.DeleteFileSystemResponse.wrap)
        .provideEnvironment(r)
    def createVolumeFromBackup(
        request: CreateVolumeFromBackupRequest
    ): IO[AwsError, zio.aws.fsx.model.CreateVolumeFromBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupRequest,
        CreateVolumeFromBackupResponse
      ]("createVolumeFromBackup", api.createVolumeFromBackup)(
        request.buildAwsValue()
      ).map(zio.aws.fsx.model.CreateVolumeFromBackupResponse.wrap)
        .provideEnvironment(r)
    def cancelDataRepositoryTask(request: CancelDataRepositoryTaskRequest): IO[
      AwsError,
      zio.aws.fsx.model.CancelDataRepositoryTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskRequest,
      CancelDataRepositoryTaskResponse
    ]("cancelDataRepositoryTask", api.cancelDataRepositoryTask)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.CancelDataRepositoryTaskResponse.wrap)
      .provideEnvironment(r)
    def describeSnapshots(
        request: DescribeSnapshotsRequest
    ): ZStream[Any, AwsError, zio.aws.fsx.model.Snapshot.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest,
        DescribeSnapshotsResponse,
        Snapshot
      ](
        "describeSnapshots",
        api.describeSnapshots,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.snapshots().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.fsx.model.Snapshot.wrap(item))
        .provideEnvironment(r)
    def describeSnapshotsPaginated(
        request: DescribeSnapshotsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.DescribeSnapshotsRequest,
      DescribeSnapshotsResponse
    ]("describeSnapshots", api.describeSnapshots)(request.buildAwsValue())
      .map(zio.aws.fsx.model.DescribeSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def deleteBackup(
        request: DeleteBackupRequest
    ): IO[AwsError, zio.aws.fsx.model.DeleteBackupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.DeleteBackupRequest,
        DeleteBackupResponse
      ]("deleteBackup", api.deleteBackup)(request.buildAwsValue())
        .map(zio.aws.fsx.model.DeleteBackupResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.fsx.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.fsx.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.fsx.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.fsx.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteVolume(
        request: DeleteVolumeRequest
    ): IO[AwsError, zio.aws.fsx.model.DeleteVolumeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.DeleteVolumeRequest,
        DeleteVolumeResponse
      ]("deleteVolume", api.deleteVolume)(request.buildAwsValue())
        .map(zio.aws.fsx.model.DeleteVolumeResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.fsx.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.fsx.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateStorageVirtualMachine(
        request: UpdateStorageVirtualMachineRequest
    ): IO[
      AwsError,
      zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineRequest,
      UpdateStorageVirtualMachineResponse
    ]("updateStorageVirtualMachine", api.updateStorageVirtualMachine)(
      request.buildAwsValue()
    ).map(zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.wrap)
      .provideEnvironment(r)
    def createSnapshot(
        request: CreateSnapshotRequest
    ): IO[AwsError, zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.fsx.model.CreateSnapshotRequest,
        CreateSnapshotResponse
      ]("createSnapshot", api.createSnapshot)(request.buildAwsValue())
        .map(zio.aws.fsx.model.CreateSnapshotResponse.wrap)
        .provideEnvironment(r)
  }
  def disassociateFileSystemAliases(
      request: DisassociateFileSystemAliasesRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DisassociateFileSystemAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateFileSystemAliases(request))
  def deleteDataRepositoryAssociation(
      request: DeleteDataRepositoryAssociationRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataRepositoryAssociation(request))
  def createFileSystemFromBackup(
      request: CreateFileSystemFromBackupRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CreateFileSystemFromBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFileSystemFromBackup(request))
  def associateFileSystemAliases(
      request: AssociateFileSystemAliasesRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.AssociateFileSystemAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateFileSystemAliases(request))
  def createDataRepositoryAssociation(
      request: CreateDataRepositoryAssociationRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CreateDataRepositoryAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataRepositoryAssociation(request))
  def updateFileSystem(request: UpdateFileSystemRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.UpdateFileSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFileSystem(request))
  def describeStorageVirtualMachines(
      request: DescribeStorageVirtualMachinesRequest
  ): ZStream[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.StorageVirtualMachine.ReadOnly
  ] = ZStream.serviceWithStream(_.describeStorageVirtualMachines(request))
  def describeStorageVirtualMachinesPaginated(
      request: DescribeStorageVirtualMachinesRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStorageVirtualMachinesPaginated(request))
  def createBackup(request: CreateBackupRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CreateBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackup(request))
  def restoreVolumeFromSnapshot(request: RestoreVolumeFromSnapshotRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreVolumeFromSnapshot(request))
  def describeBackups(
      request: DescribeBackupsRequest
  ): ZStream[zio.aws.fsx.FSx, AwsError, zio.aws.fsx.model.Backup.ReadOnly] =
    ZStream.serviceWithStream(_.describeBackups(request))
  def describeBackupsPaginated(request: DescribeBackupsRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DescribeBackupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBackupsPaginated(request))
  def describeFileSystemAliases(
      request: DescribeFileSystemAliasesRequest
  ): ZStream[zio.aws.fsx.FSx, AwsError, zio.aws.fsx.model.Alias.ReadOnly] =
    ZStream.serviceWithStream(_.describeFileSystemAliases(request))
  def describeFileSystemAliasesPaginated(
      request: DescribeFileSystemAliasesRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFileSystemAliasesPaginated(request))
  def updateDataRepositoryAssociation(
      request: UpdateDataRepositoryAssociationRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataRepositoryAssociation(request))
  def releaseFileSystemNfsV3Locks(
      request: ReleaseFileSystemNfsV3LocksRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.releaseFileSystemNfsV3Locks(request))
  def createStorageVirtualMachine(
      request: CreateStorageVirtualMachineRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CreateStorageVirtualMachineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStorageVirtualMachine(request))
  def describeVolumes(
      request: DescribeVolumesRequest
  ): ZStream[zio.aws.fsx.FSx, AwsError, zio.aws.fsx.model.Volume.ReadOnly] =
    ZStream.serviceWithStream(_.describeVolumes(request))
  def describeVolumesPaginated(request: DescribeVolumesRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DescribeVolumesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVolumesPaginated(request))
  def createVolume(request: CreateVolumeRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CreateVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVolume(request))
  def deleteSnapshot(request: DeleteSnapshotRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DeleteSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSnapshot(request))
  def copyBackup(request: CopyBackupRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CopyBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyBackup(request))
  def deleteStorageVirtualMachine(
      request: DeleteStorageVirtualMachineRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DeleteStorageVirtualMachineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStorageVirtualMachine(request))
  def updateVolume(request: UpdateVolumeRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.UpdateVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVolume(request))
  def describeDataRepositoryAssociations(
      request: DescribeDataRepositoryAssociationsRequest
  ): ZStream[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDataRepositoryAssociations(request))
  def describeDataRepositoryAssociationsPaginated(
      request: DescribeDataRepositoryAssociationsRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataRepositoryAssociationsPaginated(request))
  def createFileSystem(request: CreateFileSystemRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CreateFileSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFileSystem(request))
  def describeDataRepositoryTasks(
      request: DescribeDataRepositoryTasksRequest
  ): ZStream[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DataRepositoryTask.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDataRepositoryTasks(request))
  def describeDataRepositoryTasksPaginated(
      request: DescribeDataRepositoryTasksRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DescribeDataRepositoryTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataRepositoryTasksPaginated(request))
  def updateSnapshot(request: UpdateSnapshotRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSnapshot(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeFileSystems(
      request: DescribeFileSystemsRequest
  ): ZStream[zio.aws.fsx.FSx, AwsError, zio.aws.fsx.model.FileSystem.ReadOnly] =
    ZStream.serviceWithStream(_.describeFileSystems(request))
  def describeFileSystemsPaginated(request: DescribeFileSystemsRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DescribeFileSystemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFileSystemsPaginated(request))
  def createDataRepositoryTask(request: CreateDataRepositoryTaskRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CreateDataRepositoryTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataRepositoryTask(request))
  def deleteFileSystem(request: DeleteFileSystemRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFileSystem(request))
  def createVolumeFromBackup(request: CreateVolumeFromBackupRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CreateVolumeFromBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVolumeFromBackup(request))
  def cancelDataRepositoryTask(request: CancelDataRepositoryTaskRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CancelDataRepositoryTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelDataRepositoryTask(request))
  def describeSnapshots(
      request: DescribeSnapshotsRequest
  ): ZStream[zio.aws.fsx.FSx, AwsError, zio.aws.fsx.model.Snapshot.ReadOnly] =
    ZStream.serviceWithStream(_.describeSnapshots(request))
  def describeSnapshotsPaginated(
      request: DescribeSnapshotsRequest
  ): ZIO[zio.aws.fsx.FSx, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeSnapshotsPaginated(request))
  def deleteBackup(request: DeleteBackupRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DeleteBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBackup(request))
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[zio.aws.fsx.FSx, AwsError, zio.aws.fsx.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def deleteVolume(request: DeleteVolumeRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.DeleteVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVolume(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateStorageVirtualMachine(
      request: UpdateStorageVirtualMachineRequest
  ): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStorageVirtualMachine(request))
  def createSnapshot(request: CreateSnapshotRequest): ZIO[
    zio.aws.fsx.FSx,
    AwsError,
    zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSnapshot(request))
}
