package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  ResourceARN,
  DirectoryId,
  ActiveDirectoryFullyQualifiedName
}
import scala.jdk.CollectionConverters._
final case class ActiveDirectoryBackupAttributes(
    domainName: Option[ActiveDirectoryFullyQualifiedName] = None,
    activeDirectoryId: Option[DirectoryId] = None,
    resourceARN: Option[ResourceARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes = {
    import ActiveDirectoryBackupAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes
      .builder()
      .optionallyWith(
        domainName.map(value =>
          ActiveDirectoryFullyQualifiedName.unwrap(value): java.lang.String
        )
      )(_.domainName)
      .optionallyWith(
        activeDirectoryId.map(value =>
          DirectoryId.unwrap(value): java.lang.String
        )
      )(_.activeDirectoryId)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.ActiveDirectoryBackupAttributes.ReadOnly =
    zio.aws.fsx.model.ActiveDirectoryBackupAttributes.wrap(buildAwsValue())
}
object ActiveDirectoryBackupAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.ActiveDirectoryBackupAttributes =
      zio.aws.fsx.model.ActiveDirectoryBackupAttributes(
        domainName.map(value => value),
        activeDirectoryId.map(value => value),
        resourceARN.map(value => value)
      )
    def domainName: Option[ActiveDirectoryFullyQualifiedName]
    def activeDirectoryId: Option[DirectoryId]
    def resourceARN: Option[ResourceARN]
    def getDomainName: ZIO[Any, AwsError, ActiveDirectoryFullyQualifiedName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getActiveDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("activeDirectoryId", activeDirectoryId)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes
  ) extends zio.aws.fsx.model.ActiveDirectoryBackupAttributes.ReadOnly {
    override val domainName: Option[ActiveDirectoryFullyQualifiedName] = scala
      .Option(impl.domainName())
      .map(value =>
        zio.aws.fsx.model.primitives.ActiveDirectoryFullyQualifiedName(value)
      )
    override val activeDirectoryId: Option[DirectoryId] = scala
      .Option(impl.activeDirectoryId())
      .map(value => zio.aws.fsx.model.primitives.DirectoryId(value))
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.ActiveDirectoryBackupAttributes
  ): zio.aws.fsx.model.ActiveDirectoryBackupAttributes.ReadOnly = new Wrapper(
    impl
  )
}
