package zio.aws.fsx.model
import java.time.Instant
import zio.aws.fsx.model.primitives.{RequestTime, ProgressPercent}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AdministrativeAction(
    administrativeActionType: Option[
      zio.aws.fsx.model.AdministrativeActionType
    ] = None,
    progressPercent: Option[ProgressPercent] = None,
    requestTime: Option[RequestTime] = None,
    status: Option[zio.aws.fsx.model.Status] = None,
    targetFileSystemValues: Option[zio.aws.fsx.model.FileSystem] = None,
    failureDetails: Option[
      zio.aws.fsx.model.AdministrativeActionFailureDetails
    ] = None,
    targetVolumeValues: Option[zio.aws.fsx.model.Volume] = None,
    targetSnapshotValues: Option[zio.aws.fsx.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.AdministrativeAction = {
    import AdministrativeAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.AdministrativeAction
      .builder()
      .optionallyWith(administrativeActionType.map(value => value.unwrap))(
        _.administrativeActionType
      )
      .optionallyWith(
        progressPercent.map(value => ProgressPercent.unwrap(value): Integer)
      )(_.progressPercent)
      .optionallyWith(
        requestTime.map(value => RequestTime.unwrap(value): Instant)
      )(_.requestTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        targetFileSystemValues.map(value => value.buildAwsValue())
      )(_.targetFileSystemValues)
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(targetVolumeValues.map(value => value.buildAwsValue()))(
        _.targetVolumeValues
      )
      .optionallyWith(targetSnapshotValues.map(value => value.buildAwsValue()))(
        _.targetSnapshotValues
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.AdministrativeAction.ReadOnly =
    zio.aws.fsx.model.AdministrativeAction.wrap(buildAwsValue())
}
object AdministrativeAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.AdministrativeAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.AdministrativeAction =
      zio.aws.fsx.model.AdministrativeAction(
        administrativeActionType.map(value => value),
        progressPercent.map(value => value),
        requestTime.map(value => value),
        status.map(value => value),
        targetFileSystemValues.map(value => value.asEditable),
        failureDetails.map(value => value.asEditable),
        targetVolumeValues.map(value => value.asEditable),
        targetSnapshotValues.map(value => value.asEditable)
      )
    def administrativeActionType
        : Option[zio.aws.fsx.model.AdministrativeActionType]
    def progressPercent: Option[ProgressPercent]
    def requestTime: Option[RequestTime]
    def status: Option[zio.aws.fsx.model.Status]
    def targetFileSystemValues: Option[zio.aws.fsx.model.FileSystem.ReadOnly]
    def failureDetails
        : Option[zio.aws.fsx.model.AdministrativeActionFailureDetails.ReadOnly]
    def targetVolumeValues: Option[zio.aws.fsx.model.Volume.ReadOnly]
    def targetSnapshotValues: Option[zio.aws.fsx.model.Snapshot.ReadOnly]
    def getAdministrativeActionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.AdministrativeActionType] =
      AwsError.unwrapOptionField(
        "administrativeActionType",
        administrativeActionType
      )
    def getProgressPercent: ZIO[Any, AwsError, ProgressPercent] =
      AwsError.unwrapOptionField("progressPercent", progressPercent)
    def getRequestTime: ZIO[Any, AwsError, RequestTime] =
      AwsError.unwrapOptionField("requestTime", requestTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.fsx.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getTargetFileSystemValues
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystem.ReadOnly] = AwsError
      .unwrapOptionField("targetFileSystemValues", targetFileSystemValues)
    def getFailureDetails: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.AdministrativeActionFailureDetails.ReadOnly
    ] = AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getTargetVolumeValues
        : ZIO[Any, AwsError, zio.aws.fsx.model.Volume.ReadOnly] =
      AwsError.unwrapOptionField("targetVolumeValues", targetVolumeValues)
    def getTargetSnapshotValues
        : ZIO[Any, AwsError, zio.aws.fsx.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("targetSnapshotValues", targetSnapshotValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.AdministrativeAction
  ) extends zio.aws.fsx.model.AdministrativeAction.ReadOnly {
    override val administrativeActionType
        : Option[zio.aws.fsx.model.AdministrativeActionType] = scala
      .Option(impl.administrativeActionType())
      .map(value => zio.aws.fsx.model.AdministrativeActionType.wrap(value))
    override val progressPercent: Option[ProgressPercent] = scala
      .Option(impl.progressPercent())
      .map(value => zio.aws.fsx.model.primitives.ProgressPercent(value))
    override val requestTime: Option[RequestTime] = scala
      .Option(impl.requestTime())
      .map(value => zio.aws.fsx.model.primitives.RequestTime(value))
    override val status: Option[zio.aws.fsx.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.fsx.model.Status.wrap(value))
    override val targetFileSystemValues
        : Option[zio.aws.fsx.model.FileSystem.ReadOnly] = scala
      .Option(impl.targetFileSystemValues())
      .map(value => zio.aws.fsx.model.FileSystem.wrap(value))
    override val failureDetails: Option[
      zio.aws.fsx.model.AdministrativeActionFailureDetails.ReadOnly
    ] = scala
      .Option(impl.failureDetails())
      .map(value =>
        zio.aws.fsx.model.AdministrativeActionFailureDetails.wrap(value)
      )
    override val targetVolumeValues: Option[zio.aws.fsx.model.Volume.ReadOnly] =
      scala
        .Option(impl.targetVolumeValues())
        .map(value => zio.aws.fsx.model.Volume.wrap(value))
    override val targetSnapshotValues
        : Option[zio.aws.fsx.model.Snapshot.ReadOnly] = scala
      .Option(impl.targetSnapshotValues())
      .map(value => zio.aws.fsx.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.AdministrativeAction
  ): zio.aws.fsx.model.AdministrativeAction.ReadOnly = new Wrapper(impl)
}
