package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.ErrorMessage
import scala.jdk.CollectionConverters._
final case class AdministrativeActionFailureDetails(
    message: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.AdministrativeActionFailureDetails = {
    import AdministrativeActionFailureDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.AdministrativeActionFailureDetails
      .builder()
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.AdministrativeActionFailureDetails.ReadOnly =
    zio.aws.fsx.model.AdministrativeActionFailureDetails.wrap(buildAwsValue())
}
object AdministrativeActionFailureDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.AdministrativeActionFailureDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.AdministrativeActionFailureDetails =
      zio.aws.fsx.model
        .AdministrativeActionFailureDetails(message.map(value => value))
    def message: Option[ErrorMessage]
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.AdministrativeActionFailureDetails
  ) extends zio.aws.fsx.model.AdministrativeActionFailureDetails.ReadOnly {
    override val message: Option[ErrorMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.fsx.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.AdministrativeActionFailureDetails
  ): zio.aws.fsx.model.AdministrativeActionFailureDetails.ReadOnly =
    new Wrapper(impl)
}
