package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AutoExportPolicy(
    events: Option[Iterable[zio.aws.fsx.model.EventType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.AutoExportPolicy = {
    import AutoExportPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.AutoExportPolicy
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.AutoExportPolicy.ReadOnly =
    zio.aws.fsx.model.AutoExportPolicy.wrap(buildAwsValue())
}
object AutoExportPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.AutoExportPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.AutoExportPolicy =
      zio.aws.fsx.model.AutoExportPolicy(events.map(value => value))
    def events: Option[List[zio.aws.fsx.model.EventType]]
    def getEvents: ZIO[Any, AwsError, List[zio.aws.fsx.model.EventType]] =
      AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.AutoExportPolicy
  ) extends zio.aws.fsx.model.AutoExportPolicy.ReadOnly {
    override val events: Option[List[zio.aws.fsx.model.EventType]] = scala
      .Option(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.EventType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.AutoExportPolicy
  ): zio.aws.fsx.model.AutoExportPolicy.ReadOnly = new Wrapper(impl)
}
