package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.TaskId
import scala.jdk.CollectionConverters._
final case class CancelDataRepositoryTaskResponse(
    lifecycle: Option[zio.aws.fsx.model.DataRepositoryTaskLifecycle] = None,
    taskId: Option[TaskId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskResponse = {
    import CancelDataRepositoryTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskResponse
      .builder()
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CancelDataRepositoryTaskResponse.ReadOnly =
    zio.aws.fsx.model.CancelDataRepositoryTaskResponse.wrap(buildAwsValue())
}
object CancelDataRepositoryTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CancelDataRepositoryTaskResponse =
      zio.aws.fsx.model.CancelDataRepositoryTaskResponse(
        lifecycle.map(value => value),
        taskId.map(value => value)
      )
    def lifecycle: Option[zio.aws.fsx.model.DataRepositoryTaskLifecycle]
    def taskId: Option[TaskId]
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataRepositoryTaskLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskResponse
  ) extends zio.aws.fsx.model.CancelDataRepositoryTaskResponse.ReadOnly {
    override val lifecycle
        : Option[zio.aws.fsx.model.DataRepositoryTaskLifecycle] = scala
      .Option(impl.lifecycle())
      .map(value => zio.aws.fsx.model.DataRepositoryTaskLifecycle.wrap(value))
    override val taskId: Option[TaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.fsx.model.primitives.TaskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskResponse
  ): zio.aws.fsx.model.CancelDataRepositoryTaskResponse.ReadOnly = new Wrapper(
    impl
  )
}
