package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  ClientRequestToken,
  SourceBackupId,
  Flag,
  KmsKeyId,
  Region
}
import scala.jdk.CollectionConverters._
final case class CopyBackupRequest(
    clientRequestToken: Option[ClientRequestToken] = None,
    sourceBackupId: SourceBackupId,
    sourceRegion: Option[Region] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    copyTags: Option[Flag] = None,
    tags: Option[Iterable[zio.aws.fsx.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CopyBackupRequest = {
    import CopyBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CopyBackupRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .sourceBackupId(SourceBackupId.unwrap(sourceBackupId): java.lang.String)
      .optionallyWith(
        sourceRegion.map(value => Region.unwrap(value): java.lang.String)
      )(_.sourceRegion)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        copyTags.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTags)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CopyBackupRequest.ReadOnly =
    zio.aws.fsx.model.CopyBackupRequest.wrap(buildAwsValue())
}
object CopyBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CopyBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CopyBackupRequest =
      zio.aws.fsx.model.CopyBackupRequest(
        clientRequestToken.map(value => value),
        sourceBackupId,
        sourceRegion.map(value => value),
        kmsKeyId.map(value => value),
        copyTags.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientRequestToken: Option[ClientRequestToken]
    def sourceBackupId: SourceBackupId
    def sourceRegion: Option[Region]
    def kmsKeyId: Option[KmsKeyId]
    def copyTags: Option[Flag]
    def tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getSourceBackupId: ZIO[Any, Nothing, SourceBackupId] =
      ZIO.succeed(sourceBackupId)
    def getSourceRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("sourceRegion", sourceRegion)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCopyTags: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CopyBackupRequest
  ) extends zio.aws.fsx.model.CopyBackupRequest.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val sourceBackupId: SourceBackupId =
      zio.aws.fsx.model.primitives.SourceBackupId(impl.sourceBackupId())
    override val sourceRegion: Option[Region] = scala
      .Option(impl.sourceRegion())
      .map(value => zio.aws.fsx.model.primitives.Region(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.fsx.model.primitives.KmsKeyId(value))
    override val copyTags: Option[Flag] = scala
      .Option(impl.copyTags())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val tags: Option[List[zio.aws.fsx.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CopyBackupRequest
  ): zio.aws.fsx.model.CopyBackupRequest.ReadOnly = new Wrapper(impl)
}
