package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopyBackupResponse(
    backup: Option[zio.aws.fsx.model.Backup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CopyBackupResponse = {
    import CopyBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CopyBackupResponse
      .builder()
      .optionallyWith(backup.map(value => value.buildAwsValue()))(_.backup)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CopyBackupResponse.ReadOnly =
    zio.aws.fsx.model.CopyBackupResponse.wrap(buildAwsValue())
}
object CopyBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CopyBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CopyBackupResponse = zio.aws.fsx.model
      .CopyBackupResponse(backup.map(value => value.asEditable))
    def backup: Option[zio.aws.fsx.model.Backup.ReadOnly]
    def getBackup: ZIO[Any, AwsError, zio.aws.fsx.model.Backup.ReadOnly] =
      AwsError.unwrapOptionField("backup", backup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CopyBackupResponse
  ) extends zio.aws.fsx.model.CopyBackupResponse.ReadOnly {
    override val backup: Option[zio.aws.fsx.model.Backup.ReadOnly] = scala
      .Option(impl.backup())
      .map(value => zio.aws.fsx.model.Backup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CopyBackupResponse
  ): zio.aws.fsx.model.CopyBackupResponse.ReadOnly = new Wrapper(impl)
}
